/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the monitoring of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Monitoring implements ToCopyableBuilder<Monitoring.Builder, Monitoring> {
    private final String state;

    private Monitoring(BuilderImpl builder) {
        this.state = builder.state;
    }

    /**
     * <p>
     * Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.
     * </p>
     * 
     * @return Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.
     * @see MonitoringState
     */
    public String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Monitoring)) {
            return false;
        }
        Monitoring other = (Monitoring) obj;
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Monitoring> {
        /**
         * <p>
         * Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.
         * </p>
         * 
         * @param state
         *        Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.
         * @see MonitoringState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringState
         */
        Builder state(String state);

        /**
         * <p>
         * Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.
         * </p>
         * 
         * @param state
         *        Indicates whether detailed monitoring is enabled. Otherwise, basic monitoring is enabled.
         * @see MonitoringState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MonitoringState
         */
        Builder state(MonitoringState state);
    }

    private static final class BuilderImpl implements Builder {
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Monitoring model) {
            setState(model.state);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(MonitoringState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(MonitoringState state) {
            this.state(state.toString());
        }

        @Override
        public Monitoring build() {
            return new Monitoring(this);
        }
    }
}
