/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of a moving Elastic IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MovingAddressStatus implements ToCopyableBuilder<MovingAddressStatus.Builder, MovingAddressStatus> {
    private final String moveStatus;

    private final String publicIp;

    private MovingAddressStatus(BuilderImpl builder) {
        this.moveStatus = builder.moveStatus;
        this.publicIp = builder.publicIp;
    }

    /**
     * <p>
     * The status of the Elastic IP address that's being moved to the EC2-VPC platform, or restored to the EC2-Classic
     * platform.
     * </p>
     * 
     * @return The status of the Elastic IP address that's being moved to the EC2-VPC platform, or restored to the
     *         EC2-Classic platform.
     * @see MoveStatus
     */
    public String moveStatus() {
        return moveStatus;
    }

    /**
     * <p>
     * The Elastic IP address.
     * </p>
     * 
     * @return The Elastic IP address.
     */
    public String publicIp() {
        return publicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((moveStatus() == null) ? 0 : moveStatus().hashCode());
        hashCode = 31 * hashCode + ((publicIp() == null) ? 0 : publicIp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MovingAddressStatus)) {
            return false;
        }
        MovingAddressStatus other = (MovingAddressStatus) obj;
        if (other.moveStatus() == null ^ this.moveStatus() == null) {
            return false;
        }
        if (other.moveStatus() != null && !other.moveStatus().equals(this.moveStatus())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (moveStatus() != null) {
            sb.append("MoveStatus: ").append(moveStatus()).append(",");
        }
        if (publicIp() != null) {
            sb.append("PublicIp: ").append(publicIp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, MovingAddressStatus> {
        /**
         * <p>
         * The status of the Elastic IP address that's being moved to the EC2-VPC platform, or restored to the
         * EC2-Classic platform.
         * </p>
         * 
         * @param moveStatus
         *        The status of the Elastic IP address that's being moved to the EC2-VPC platform, or restored to the
         *        EC2-Classic platform.
         * @see MoveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MoveStatus
         */
        Builder moveStatus(String moveStatus);

        /**
         * <p>
         * The status of the Elastic IP address that's being moved to the EC2-VPC platform, or restored to the
         * EC2-Classic platform.
         * </p>
         * 
         * @param moveStatus
         *        The status of the Elastic IP address that's being moved to the EC2-VPC platform, or restored to the
         *        EC2-Classic platform.
         * @see MoveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MoveStatus
         */
        Builder moveStatus(MoveStatus moveStatus);

        /**
         * <p>
         * The Elastic IP address.
         * </p>
         * 
         * @param publicIp
         *        The Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);
    }

    private static final class BuilderImpl implements Builder {
        private String moveStatus;

        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(MovingAddressStatus model) {
            setMoveStatus(model.moveStatus);
            setPublicIp(model.publicIp);
        }

        public final String getMoveStatus() {
            return moveStatus;
        }

        @Override
        public final Builder moveStatus(String moveStatus) {
            this.moveStatus = moveStatus;
            return this;
        }

        @Override
        public final Builder moveStatus(MoveStatus moveStatus) {
            this.moveStatus(moveStatus.toString());
            return this;
        }

        public final void setMoveStatus(String moveStatus) {
            this.moveStatus = moveStatus;
        }

        public final void setMoveStatus(MoveStatus moveStatus) {
            this.moveStatus(moveStatus.toString());
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public MovingAddressStatus build() {
            return new MovingAddressStatus(this);
        }
    }
}
