/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the price for a Reserved Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PriceSchedule implements ToCopyableBuilder<PriceSchedule.Builder, PriceSchedule> {
    private final Boolean active;

    private final String currencyCode;

    private final Double price;

    private final Long term;

    private PriceSchedule(BuilderImpl builder) {
        this.active = builder.active;
        this.currencyCode = builder.currencyCode;
        this.price = builder.price;
        this.term = builder.term;
    }

    /**
     * <p>
     * The current price schedule, as determined by the term remaining for the Reserved Instance in the listing.
     * </p>
     * <p>
     * A specific price schedule is always in effect, but only one price schedule can be active at any time. Take, for
     * example, a Reserved Instance listing that has five months remaining in its term. When you specify price schedules
     * for five months and two months, this means that schedule 1, covering the first three months of the remaining
     * term, will be active during months 5, 4, and 3. Then schedule 2, covering the last two months of the term, will
     * be active for months 2 and 1.
     * </p>
     * 
     * @return The current price schedule, as determined by the term remaining for the Reserved Instance in the
     *         listing.</p>
     *         <p>
     *         A specific price schedule is always in effect, but only one price schedule can be active at any time.
     *         Take, for example, a Reserved Instance listing that has five months remaining in its term. When you
     *         specify price schedules for five months and two months, this means that schedule 1, covering the first
     *         three months of the remaining term, will be active during months 5, 4, and 3. Then schedule 2, covering
     *         the last two months of the term, will be active for months 2 and 1.
     */
    public Boolean active() {
        return active;
    }

    /**
     * <p>
     * The currency for transacting the Reserved Instance resale. At this time, the only supported currency is
     * <code>USD</code>.
     * </p>
     * 
     * @return The currency for transacting the Reserved Instance resale. At this time, the only supported currency is
     *         <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The fixed price for the term.
     * </p>
     * 
     * @return The fixed price for the term.
     */
    public Double price() {
        return price;
    }

    /**
     * <p>
     * The number of months remaining in the reservation. For example, 2 is the second to the last month before the
     * capacity reservation expires.
     * </p>
     * 
     * @return The number of months remaining in the reservation. For example, 2 is the second to the last month before
     *         the capacity reservation expires.
     */
    public Long term() {
        return term;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((active() == null) ? 0 : active().hashCode());
        hashCode = 31 * hashCode + ((currencyCode() == null) ? 0 : currencyCode().hashCode());
        hashCode = 31 * hashCode + ((price() == null) ? 0 : price().hashCode());
        hashCode = 31 * hashCode + ((term() == null) ? 0 : term().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriceSchedule)) {
            return false;
        }
        PriceSchedule other = (PriceSchedule) obj;
        if (other.active() == null ^ this.active() == null) {
            return false;
        }
        if (other.active() != null && !other.active().equals(this.active())) {
            return false;
        }
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.price() == null ^ this.price() == null) {
            return false;
        }
        if (other.price() != null && !other.price().equals(this.price())) {
            return false;
        }
        if (other.term() == null ^ this.term() == null) {
            return false;
        }
        if (other.term() != null && !other.term().equals(this.term())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (active() != null) {
            sb.append("Active: ").append(active()).append(",");
        }
        if (currencyCode() != null) {
            sb.append("CurrencyCode: ").append(currencyCode()).append(",");
        }
        if (price() != null) {
            sb.append("Price: ").append(price()).append(",");
        }
        if (term() != null) {
            sb.append("Term: ").append(term()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PriceSchedule> {
        /**
         * <p>
         * The current price schedule, as determined by the term remaining for the Reserved Instance in the listing.
         * </p>
         * <p>
         * A specific price schedule is always in effect, but only one price schedule can be active at any time. Take,
         * for example, a Reserved Instance listing that has five months remaining in its term. When you specify price
         * schedules for five months and two months, this means that schedule 1, covering the first three months of the
         * remaining term, will be active during months 5, 4, and 3. Then schedule 2, covering the last two months of
         * the term, will be active for months 2 and 1.
         * </p>
         * 
         * @param active
         *        The current price schedule, as determined by the term remaining for the Reserved Instance in the
         *        listing.</p>
         *        <p>
         *        A specific price schedule is always in effect, but only one price schedule can be active at any time.
         *        Take, for example, a Reserved Instance listing that has five months remaining in its term. When you
         *        specify price schedules for five months and two months, this means that schedule 1, covering the first
         *        three months of the remaining term, will be active during months 5, 4, and 3. Then schedule 2,
         *        covering the last two months of the term, will be active for months 2 and 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * The currency for transacting the Reserved Instance resale. At this time, the only supported currency is
         * <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency for transacting the Reserved Instance resale. At this time, the only supported currency
         *        is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency for transacting the Reserved Instance resale. At this time, the only supported currency is
         * <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency for transacting the Reserved Instance resale. At this time, the only supported currency
         *        is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The fixed price for the term.
         * </p>
         * 
         * @param price
         *        The fixed price for the term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(Double price);

        /**
         * <p>
         * The number of months remaining in the reservation. For example, 2 is the second to the last month before the
         * capacity reservation expires.
         * </p>
         * 
         * @param term
         *        The number of months remaining in the reservation. For example, 2 is the second to the last month
         *        before the capacity reservation expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder term(Long term);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean active;

        private String currencyCode;

        private Double price;

        private Long term;

        private BuilderImpl() {
        }

        private BuilderImpl(PriceSchedule model) {
            setActive(model.active);
            setCurrencyCode(model.currencyCode);
            setPrice(model.price);
            setTerm(model.term);
        }

        public final Boolean getActive() {
            return active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final void setCurrencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
        }

        public final Double getPrice() {
            return price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        public final Long getTerm() {
            return term;
        }

        @Override
        public final Builder term(Long term) {
            this.term = term;
            return this;
        }

        public final void setTerm(Long term) {
            this.term = term;
        }

        @Override
        public PriceSchedule build() {
            return new PriceSchedule(this);
        }
    }
}
