/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for RequestSpotFleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RequestSpotFleetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RequestSpotFleetRequest.Builder, RequestSpotFleetRequest> {
    private final SpotFleetRequestConfigData spotFleetRequestConfig;

    private RequestSpotFleetRequest(BuilderImpl builder) {
        this.spotFleetRequestConfig = builder.spotFleetRequestConfig;
    }

    /**
     * <p>
     * The configuration for the Spot fleet request.
     * </p>
     * 
     * @return The configuration for the Spot fleet request.
     */
    public SpotFleetRequestConfigData spotFleetRequestConfig() {
        return spotFleetRequestConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((spotFleetRequestConfig() == null) ? 0 : spotFleetRequestConfig().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotFleetRequest)) {
            return false;
        }
        RequestSpotFleetRequest other = (RequestSpotFleetRequest) obj;
        if (other.spotFleetRequestConfig() == null ^ this.spotFleetRequestConfig() == null) {
            return false;
        }
        if (other.spotFleetRequestConfig() != null && !other.spotFleetRequestConfig().equals(this.spotFleetRequestConfig())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (spotFleetRequestConfig() != null) {
            sb.append("SpotFleetRequestConfig: ").append(spotFleetRequestConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RequestSpotFleetRequest> {
        /**
         * <p>
         * The configuration for the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestConfig
         *        The configuration for the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig);
    }

    private static final class BuilderImpl implements Builder {
        private SpotFleetRequestConfigData spotFleetRequestConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotFleetRequest model) {
            setSpotFleetRequestConfig(model.spotFleetRequestConfig);
        }

        public final SpotFleetRequestConfigData getSpotFleetRequestConfig() {
            return spotFleetRequestConfig;
        }

        @Override
        public final Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
            return this;
        }

        public final void setSpotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
        }

        @Override
        public RequestSpotFleetRequest build() {
            return new RequestSpotFleetRequest(this);
        }
    }
}
