/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Reservation implements ToCopyableBuilder<Reservation.Builder, Reservation> {
    private final List<GroupIdentifier> groups;

    private final List<Instance> instances;

    private final String ownerId;

    private final String requesterId;

    private final String reservationId;

    private final List<String> groupNames;

    private Reservation(BuilderImpl builder) {
        this.groups = builder.groups;
        this.instances = builder.instances;
        this.ownerId = builder.ownerId;
        this.requesterId = builder.requesterId;
        this.reservationId = builder.reservationId;
        this.groupNames = builder.groupNames;
    }

    /**
     * <p>
     * [EC2-Classic only] One or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-Classic only] One or more security groups.
     */
    public List<GroupIdentifier> groups() {
        return groups;
    }

    /**
     * <p>
     * One or more instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more instances.
     */
    public List<Instance> instances() {
        return instances;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the reservation.
     * </p>
     * 
     * @return The ID of the AWS account that owns the reservation.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The ID of the requester that launched the instances on your behalf (for example, AWS Management Console or Auto
     * Scaling).
     * </p>
     * 
     * @return The ID of the requester that launched the instances on your behalf (for example, AWS Management Console
     *         or Auto Scaling).
     */
    public String requesterId() {
        return requesterId;
    }

    /**
     * <p>
     * The ID of the reservation.
     * </p>
     * 
     * @return The ID of the reservation.
     */
    public String reservationId() {
        return reservationId;
    }

    /**
     * <p>
     * One or more security group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group names.
     */
    public List<String> groupNames() {
        return groupNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((groups() == null) ? 0 : groups().hashCode());
        hashCode = 31 * hashCode + ((instances() == null) ? 0 : instances().hashCode());
        hashCode = 31 * hashCode + ((ownerId() == null) ? 0 : ownerId().hashCode());
        hashCode = 31 * hashCode + ((requesterId() == null) ? 0 : requesterId().hashCode());
        hashCode = 31 * hashCode + ((reservationId() == null) ? 0 : reservationId().hashCode());
        hashCode = 31 * hashCode + ((groupNames() == null) ? 0 : groupNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation) obj;
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.requesterId() == null ^ this.requesterId() == null) {
            return false;
        }
        if (other.requesterId() != null && !other.requesterId().equals(this.requesterId())) {
            return false;
        }
        if (other.reservationId() == null ^ this.reservationId() == null) {
            return false;
        }
        if (other.reservationId() != null && !other.reservationId().equals(this.reservationId())) {
            return false;
        }
        if (other.groupNames() == null ^ this.groupNames() == null) {
            return false;
        }
        if (other.groupNames() != null && !other.groupNames().equals(this.groupNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (groups() != null) {
            sb.append("Groups: ").append(groups()).append(",");
        }
        if (instances() != null) {
            sb.append("Instances: ").append(instances()).append(",");
        }
        if (ownerId() != null) {
            sb.append("OwnerId: ").append(ownerId()).append(",");
        }
        if (requesterId() != null) {
            sb.append("RequesterId: ").append(requesterId()).append(",");
        }
        if (reservationId() != null) {
            sb.append("ReservationId: ").append(reservationId()).append(",");
        }
        if (groupNames() != null) {
            sb.append("GroupNames: ").append(groupNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Reservation> {
        /**
         * <p>
         * [EC2-Classic only] One or more security groups.
         * </p>
         * 
         * @param groups
         *        [EC2-Classic only] One or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * [EC2-Classic only] One or more security groups.
         * </p>
         * 
         * @param groups
         *        [EC2-Classic only] One or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * One or more instances.
         * </p>
         * 
         * @param instances
         *        One or more instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<Instance> instances);

        /**
         * <p>
         * One or more instances.
         * </p>
         * 
         * @param instances
         *        One or more instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Instance... instances);

        /**
         * <p>
         * The ID of the AWS account that owns the reservation.
         * </p>
         * 
         * @param ownerId
         *        The ID of the AWS account that owns the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The ID of the requester that launched the instances on your behalf (for example, AWS Management Console or
         * Auto Scaling).
         * </p>
         * 
         * @param requesterId
         *        The ID of the requester that launched the instances on your behalf (for example, AWS Management
         *        Console or Auto Scaling).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterId(String requesterId);

        /**
         * <p>
         * The ID of the reservation.
         * </p>
         * 
         * @param reservationId
         *        The ID of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationId(String reservationId);

        /**
         * <p>
         * One or more security group names.
         * </p>
         * 
         * @param groupNames
         *        One or more security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(Collection<String> groupNames);

        /**
         * <p>
         * One or more security group names.
         * </p>
         * 
         * @param groupNames
         *        One or more security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(String... groupNames);
    }

    private static final class BuilderImpl implements Builder {
        private List<GroupIdentifier> groups;

        private List<Instance> instances;

        private String ownerId;

        private String requesterId;

        private String reservationId;

        private List<String> groupNames;

        private BuilderImpl() {
        }

        private BuilderImpl(Reservation model) {
            setGroups(model.groups);
            setInstances(model.instances);
            setOwnerId(model.ownerId);
            setRequesterId(model.requesterId);
            setReservationId(model.reservationId);
            setGroupNames(model.groupNames);
        }

        public final Collection<GroupIdentifier> getGroups() {
            return groups;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
        }

        public final Collection<Instance> getInstances() {
            return instances;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
        }

        @SafeVarargs
        public final void setInstances(Instance... instances) {
            instances(Arrays.asList(instances));
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getRequesterId() {
            return requesterId;
        }

        @Override
        public final Builder requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public final void setRequesterId(String requesterId) {
            this.requesterId = requesterId;
        }

        public final String getReservationId() {
            return reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        public final Collection<String> getGroupNames() {
            return groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        @SafeVarargs
        public final void setGroupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
        }

        @Override
        public Reservation build() {
            return new Reservation(this);
        }
    }
}
