/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration settings for the modified Reserved Instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstancesConfiguration implements
        ToCopyableBuilder<ReservedInstancesConfiguration.Builder, ReservedInstancesConfiguration> {
    private final String availabilityZone;

    private final Integer instanceCount;

    private final String instanceType;

    private final String platform;

    private final String scope;

    private ReservedInstancesConfiguration(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.platform = builder.platform;
        this.scope = builder.scope;
    }

    /**
     * <p>
     * The Availability Zone for the modified Reserved Instances.
     * </p>
     * 
     * @return The Availability Zone for the modified Reserved Instances.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of modified Reserved Instances.
     * </p>
     * 
     * @return The number of modified Reserved Instances.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The instance type for the modified Reserved Instances.
     * </p>
     * 
     * @return The instance type for the modified Reserved Instances.
     * @see InstanceType
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The network platform of the modified Reserved Instances, which is either EC2-Classic or EC2-VPC.
     * </p>
     * 
     * @return The network platform of the modified Reserved Instances, which is either EC2-Classic or EC2-VPC.
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * Whether the Reserved Instance is applied to instances in a region or instances in a specific Availability Zone.
     * </p>
     * 
     * @return Whether the Reserved Instance is applied to instances in a region or instances in a specific Availability
     *         Zone.
     * @see Scope
     */
    public String scope() {
        return scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((instanceCount() == null) ? 0 : instanceCount().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((platform() == null) ? 0 : platform().hashCode());
        hashCode = 31 * hashCode + ((scope() == null) ? 0 : scope().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesConfiguration)) {
            return false;
        }
        ReservedInstancesConfiguration other = (ReservedInstancesConfiguration) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.scope() == null ^ this.scope() == null) {
            return false;
        }
        if (other.scope() != null && !other.scope().equals(this.scope())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (instanceCount() != null) {
            sb.append("InstanceCount: ").append(instanceCount()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        if (scope() != null) {
            sb.append("Scope: ").append(scope()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstancesConfiguration> {
        /**
         * <p>
         * The Availability Zone for the modified Reserved Instances.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the modified Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of modified Reserved Instances.
         * </p>
         * 
         * @param instanceCount
         *        The number of modified Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The instance type for the modified Reserved Instances.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the modified Reserved Instances.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type for the modified Reserved Instances.
         * </p>
         * 
         * @param instanceType
         *        The instance type for the modified Reserved Instances.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The network platform of the modified Reserved Instances, which is either EC2-Classic or EC2-VPC.
         * </p>
         * 
         * @param platform
         *        The network platform of the modified Reserved Instances, which is either EC2-Classic or EC2-VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * Whether the Reserved Instance is applied to instances in a region or instances in a specific Availability
         * Zone.
         * </p>
         * 
         * @param scope
         *        Whether the Reserved Instance is applied to instances in a region or instances in a specific
         *        Availability Zone.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Whether the Reserved Instance is applied to instances in a region or instances in a specific Availability
         * Zone.
         * </p>
         * 
         * @param scope
         *        Whether the Reserved Instance is applied to instances in a region or instances in a specific
         *        Availability Zone.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);
    }

    private static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Integer instanceCount;

        private String instanceType;

        private String platform;

        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesConfiguration model) {
            setAvailabilityZone(model.availabilityZone);
            setInstanceCount(model.instanceCount);
            setInstanceType(model.instanceType);
            setPlatform(model.platform);
            setScope(model.scope);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final void setInstanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getScope() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final void setScope(Scope scope) {
            this.scope(scope.toString());
        }

        @Override
        public ReservedInstancesConfiguration build() {
            return new ReservedInstancesConfiguration(this);
        }
    }
}
