/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstancesOffering implements ToCopyableBuilder<ReservedInstancesOffering.Builder, ReservedInstancesOffering> {
    private final String availabilityZone;

    private final Long duration;

    private final Float fixedPrice;

    private final String instanceType;

    private final String productDescription;

    private final String reservedInstancesOfferingId;

    private final Float usagePrice;

    private final String currencyCode;

    private final String instanceTenancy;

    private final Boolean marketplace;

    private final String offeringClass;

    private final String offeringType;

    private final List<PricingDetail> pricingDetails;

    private final List<RecurringCharge> recurringCharges;

    private final String scope;

    private ReservedInstancesOffering(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.marketplace = builder.marketplace;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.pricingDetails = builder.pricingDetails;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
    }

    /**
     * <p>
     * The Availability Zone in which the Reserved Instance can be used.
     * </p>
     * 
     * @return The Availability Zone in which the Reserved Instance can be used.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The duration of the Reserved Instance, in seconds.
     * </p>
     * 
     * @return The duration of the Reserved Instance, in seconds.
     */
    public Long duration() {
        return duration;
    }

    /**
     * <p>
     * The purchase price of the Reserved Instance.
     * </p>
     * 
     * @return The purchase price of the Reserved Instance.
     */
    public Float fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The instance type on which the Reserved Instance can be used.
     * </p>
     * 
     * @return The instance type on which the Reserved Instance can be used.
     * @see InstanceType
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The Reserved Instance product platform description.
     * </p>
     * 
     * @return The Reserved Instance product platform description.
     * @see RIProductDescription
     */
    public String productDescription() {
        return productDescription;
    }

    /**
     * <p>
     * The ID of the Reserved Instance offering. This is the offering ID used in
     * <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
     * </p>
     * 
     * @return The ID of the Reserved Instance offering. This is the offering ID used in
     *         <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
     */
    public String reservedInstancesOfferingId() {
        return reservedInstancesOfferingId;
    }

    /**
     * <p>
     * The usage price of the Reserved Instance, per hour.
     * </p>
     * 
     * @return The usage price of the Reserved Instance, per hour.
     */
    public Float usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     * currency codes. At this time, the only supported currency is <code>USD</code>.
     * </p>
     * 
     * @return The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
     *         currency codes. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The tenancy of the instance.
     * </p>
     * 
     * @return The tenancy of the instance.
     * @see Tenancy
     */
    public String instanceTenancy() {
        return instanceTenancy;
    }

    /**
     * <p>
     * Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS. If it's a
     * Reserved Instance Marketplace offering, this is <code>true</code>.
     * </p>
     * 
     * @return Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS. If
     *         it's a Reserved Instance Marketplace offering, this is <code>true</code>.
     */
    public Boolean marketplace() {
        return marketplace;
    }

    /**
     * <p>
     * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value, with
     * different configurations. If <code>standard</code>, it is not possible to perform an exchange.
     * </p>
     * 
     * @return If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
     *         value, with different configurations. If <code>standard</code>, it is not possible to perform an
     *         exchange.
     * @see OfferingClassType
     */
    public String offeringClass() {
        return offeringClass;
    }

    /**
     * <p>
     * The Reserved Instance offering type.
     * </p>
     * 
     * @return The Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public String offeringType() {
        return offeringType;
    }

    /**
     * <p>
     * The pricing details of the Reserved Instance offering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The pricing details of the Reserved Instance offering.
     */
    public List<PricingDetail> pricingDetails() {
        return pricingDetails;
    }

    /**
     * <p>
     * The recurring charge tag assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The recurring charge tag assigned to the resource.
     */
    public List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    /**
     * <p>
     * Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
     * </p>
     * 
     * @return Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
     * @see Scope
     */
    public String scope() {
        return scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((duration() == null) ? 0 : duration().hashCode());
        hashCode = 31 * hashCode + ((fixedPrice() == null) ? 0 : fixedPrice().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((productDescription() == null) ? 0 : productDescription().hashCode());
        hashCode = 31 * hashCode + ((reservedInstancesOfferingId() == null) ? 0 : reservedInstancesOfferingId().hashCode());
        hashCode = 31 * hashCode + ((usagePrice() == null) ? 0 : usagePrice().hashCode());
        hashCode = 31 * hashCode + ((currencyCode() == null) ? 0 : currencyCode().hashCode());
        hashCode = 31 * hashCode + ((instanceTenancy() == null) ? 0 : instanceTenancy().hashCode());
        hashCode = 31 * hashCode + ((marketplace() == null) ? 0 : marketplace().hashCode());
        hashCode = 31 * hashCode + ((offeringClass() == null) ? 0 : offeringClass().hashCode());
        hashCode = 31 * hashCode + ((offeringType() == null) ? 0 : offeringType().hashCode());
        hashCode = 31 * hashCode + ((pricingDetails() == null) ? 0 : pricingDetails().hashCode());
        hashCode = 31 * hashCode + ((recurringCharges() == null) ? 0 : recurringCharges().hashCode());
        hashCode = 31 * hashCode + ((scope() == null) ? 0 : scope().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesOffering)) {
            return false;
        }
        ReservedInstancesOffering other = (ReservedInstancesOffering) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.fixedPrice() == null ^ this.fixedPrice() == null) {
            return false;
        }
        if (other.fixedPrice() != null && !other.fixedPrice().equals(this.fixedPrice())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.productDescription() == null ^ this.productDescription() == null) {
            return false;
        }
        if (other.productDescription() != null && !other.productDescription().equals(this.productDescription())) {
            return false;
        }
        if (other.reservedInstancesOfferingId() == null ^ this.reservedInstancesOfferingId() == null) {
            return false;
        }
        if (other.reservedInstancesOfferingId() != null
                && !other.reservedInstancesOfferingId().equals(this.reservedInstancesOfferingId())) {
            return false;
        }
        if (other.usagePrice() == null ^ this.usagePrice() == null) {
            return false;
        }
        if (other.usagePrice() != null && !other.usagePrice().equals(this.usagePrice())) {
            return false;
        }
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.instanceTenancy() == null ^ this.instanceTenancy() == null) {
            return false;
        }
        if (other.instanceTenancy() != null && !other.instanceTenancy().equals(this.instanceTenancy())) {
            return false;
        }
        if (other.marketplace() == null ^ this.marketplace() == null) {
            return false;
        }
        if (other.marketplace() != null && !other.marketplace().equals(this.marketplace())) {
            return false;
        }
        if (other.offeringClass() == null ^ this.offeringClass() == null) {
            return false;
        }
        if (other.offeringClass() != null && !other.offeringClass().equals(this.offeringClass())) {
            return false;
        }
        if (other.offeringType() == null ^ this.offeringType() == null) {
            return false;
        }
        if (other.offeringType() != null && !other.offeringType().equals(this.offeringType())) {
            return false;
        }
        if (other.pricingDetails() == null ^ this.pricingDetails() == null) {
            return false;
        }
        if (other.pricingDetails() != null && !other.pricingDetails().equals(this.pricingDetails())) {
            return false;
        }
        if (other.recurringCharges() == null ^ this.recurringCharges() == null) {
            return false;
        }
        if (other.recurringCharges() != null && !other.recurringCharges().equals(this.recurringCharges())) {
            return false;
        }
        if (other.scope() == null ^ this.scope() == null) {
            return false;
        }
        if (other.scope() != null && !other.scope().equals(this.scope())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (duration() != null) {
            sb.append("Duration: ").append(duration()).append(",");
        }
        if (fixedPrice() != null) {
            sb.append("FixedPrice: ").append(fixedPrice()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (productDescription() != null) {
            sb.append("ProductDescription: ").append(productDescription()).append(",");
        }
        if (reservedInstancesOfferingId() != null) {
            sb.append("ReservedInstancesOfferingId: ").append(reservedInstancesOfferingId()).append(",");
        }
        if (usagePrice() != null) {
            sb.append("UsagePrice: ").append(usagePrice()).append(",");
        }
        if (currencyCode() != null) {
            sb.append("CurrencyCode: ").append(currencyCode()).append(",");
        }
        if (instanceTenancy() != null) {
            sb.append("InstanceTenancy: ").append(instanceTenancy()).append(",");
        }
        if (marketplace() != null) {
            sb.append("Marketplace: ").append(marketplace()).append(",");
        }
        if (offeringClass() != null) {
            sb.append("OfferingClass: ").append(offeringClass()).append(",");
        }
        if (offeringType() != null) {
            sb.append("OfferingType: ").append(offeringType()).append(",");
        }
        if (pricingDetails() != null) {
            sb.append("PricingDetails: ").append(pricingDetails()).append(",");
        }
        if (recurringCharges() != null) {
            sb.append("RecurringCharges: ").append(recurringCharges()).append(",");
        }
        if (scope() != null) {
            sb.append("Scope: ").append(scope()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstancesOffering> {
        /**
         * <p>
         * The Availability Zone in which the Reserved Instance can be used.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the Reserved Instance can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The duration of the Reserved Instance, in seconds.
         * </p>
         * 
         * @param duration
         *        The duration of the Reserved Instance, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * The purchase price of the Reserved Instance.
         * </p>
         * 
         * @param fixedPrice
         *        The purchase price of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Float fixedPrice);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(RIProductDescription productDescription);

        /**
         * <p>
         * The ID of the Reserved Instance offering. This is the offering ID used in
         * <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
         * </p>
         * 
         * @param reservedInstancesOfferingId
         *        The ID of the Reserved Instance offering. This is the offering ID used in
         *        <a>GetReservedInstancesExchangeQuote</a> to confirm that an exchange can be made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesOfferingId(String reservedInstancesOfferingId);

        /**
         * <p>
         * The usage price of the Reserved Instance, per hour.
         * </p>
         * 
         * @param usagePrice
         *        The usage price of the Reserved Instance, per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Float usagePrice);

        /**
         * <p>
         * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
         * currency codes. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217
         *        standard currency codes. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217 standard
         * currency codes. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance offering you are purchasing. It's specified using ISO 4217
         *        standard currency codes. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS. If
         * it's a Reserved Instance Marketplace offering, this is <code>true</code>.
         * </p>
         * 
         * @param marketplace
         *        Indicates whether the offering is available through the Reserved Instance Marketplace (resale) or AWS.
         *        If it's a Reserved Instance Marketplace offering, this is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplace(Boolean marketplace);

        /**
         * <p>
         * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value,
         * with different configurations. If <code>standard</code>, it is not possible to perform an exchange.
         * </p>
         * 
         * @param offeringClass
         *        If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
         *        value, with different configurations. If <code>standard</code>, it is not possible to perform an
         *        exchange.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(String offeringClass);

        /**
         * <p>
         * If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary value,
         * with different configurations. If <code>standard</code>, it is not possible to perform an exchange.
         * </p>
         * 
         * @param offeringClass
         *        If <code>convertible</code> it can be exchanged for Reserved Instances of the same or higher monetary
         *        value, with different configurations. If <code>standard</code>, it is not possible to perform an
         *        exchange.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(OfferingClassType offeringClass);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(OfferingTypeValues offeringType);

        /**
         * <p>
         * The pricing details of the Reserved Instance offering.
         * </p>
         * 
         * @param pricingDetails
         *        The pricing details of the Reserved Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingDetails(Collection<PricingDetail> pricingDetails);

        /**
         * <p>
         * The pricing details of the Reserved Instance offering.
         * </p>
         * 
         * @param pricingDetails
         *        The pricing details of the Reserved Instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingDetails(PricingDetail... pricingDetails);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
         * </p>
         * 
         * @param scope
         *        Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
         * </p>
         * 
         * @param scope
         *        Whether the Reserved Instance is applied to instances in a region or an Availability Zone.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);
    }

    private static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Long duration;

        private Float fixedPrice;

        private String instanceType;

        private String productDescription;

        private String reservedInstancesOfferingId;

        private Float usagePrice;

        private String currencyCode;

        private String instanceTenancy;

        private Boolean marketplace;

        private String offeringClass;

        private String offeringType;

        private List<PricingDetail> pricingDetails;

        private List<RecurringCharge> recurringCharges;

        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesOffering model) {
            setAvailabilityZone(model.availabilityZone);
            setDuration(model.duration);
            setFixedPrice(model.fixedPrice);
            setInstanceType(model.instanceType);
            setProductDescription(model.productDescription);
            setReservedInstancesOfferingId(model.reservedInstancesOfferingId);
            setUsagePrice(model.usagePrice);
            setCurrencyCode(model.currencyCode);
            setInstanceTenancy(model.instanceTenancy);
            setMarketplace(model.marketplace);
            setOfferingClass(model.offeringClass);
            setOfferingType(model.offeringType);
            setPricingDetails(model.pricingDetails);
            setRecurringCharges(model.recurringCharges);
            setScope(model.scope);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final Float getFixedPrice() {
            return fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final void setInstanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
        }

        public final String getProductDescription() {
            return productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final void setProductDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
        }

        public final String getReservedInstancesOfferingId() {
            return reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        public final Float getUsagePrice() {
            return usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final void setCurrencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final void setInstanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
        }

        public final Boolean getMarketplace() {
            return marketplace;
        }

        @Override
        public final Builder marketplace(Boolean marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public final void setMarketplace(Boolean marketplace) {
            this.marketplace = marketplace;
        }

        public final String getOfferingClass() {
            return offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final void setOfferingClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
        }

        public final String getOfferingType() {
            return offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final void setOfferingType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
        }

        public final Collection<PricingDetail> getPricingDetails() {
            return pricingDetails;
        }

        @Override
        public final Builder pricingDetails(Collection<PricingDetail> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copy(pricingDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingDetails(PricingDetail... pricingDetails) {
            pricingDetails(Arrays.asList(pricingDetails));
            return this;
        }

        public final void setPricingDetails(Collection<PricingDetail> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copy(pricingDetails);
        }

        @SafeVarargs
        public final void setPricingDetails(PricingDetail... pricingDetails) {
            pricingDetails(Arrays.asList(pricingDetails));
        }

        public final Collection<RecurringCharge> getRecurringCharges() {
            return recurringCharges;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
        }

        @SafeVarargs
        public final void setRecurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
        }

        public final String getScope() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final void setScope(Scope scope) {
            this.scope(scope.toString());
        }

        @Override
        public ReservedInstancesOffering build() {
            return new ReservedInstancesOffering(this);
        }
    }
}
