/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RouteTable implements ToCopyableBuilder<RouteTable.Builder, RouteTable> {
    private final List<RouteTableAssociation> associations;

    private final List<PropagatingVgw> propagatingVgws;

    private final String routeTableId;

    private final List<Route> routes;

    private final List<Tag> tags;

    private final String vpcId;

    private RouteTable(BuilderImpl builder) {
        this.associations = builder.associations;
        this.propagatingVgws = builder.propagatingVgws;
        this.routeTableId = builder.routeTableId;
        this.routes = builder.routes;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The associations between the route table and one or more subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The associations between the route table and one or more subnets.
     */
    public List<RouteTableAssociation> associations() {
        return associations;
    }

    /**
     * <p>
     * Any virtual private gateway (VGW) propagating routes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any virtual private gateway (VGW) propagating routes.
     */
    public List<PropagatingVgw> propagatingVgws() {
        return propagatingVgws;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public String routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * The routes in the route table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The routes in the route table.
     */
    public List<Route> routes() {
        return routes;
    }

    /**
     * <p>
     * Any tags assigned to the route table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the route table.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((associations() == null) ? 0 : associations().hashCode());
        hashCode = 31 * hashCode + ((propagatingVgws() == null) ? 0 : propagatingVgws().hashCode());
        hashCode = 31 * hashCode + ((routeTableId() == null) ? 0 : routeTableId().hashCode());
        hashCode = 31 * hashCode + ((routes() == null) ? 0 : routes().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTable)) {
            return false;
        }
        RouteTable other = (RouteTable) obj;
        if (other.associations() == null ^ this.associations() == null) {
            return false;
        }
        if (other.associations() != null && !other.associations().equals(this.associations())) {
            return false;
        }
        if (other.propagatingVgws() == null ^ this.propagatingVgws() == null) {
            return false;
        }
        if (other.propagatingVgws() != null && !other.propagatingVgws().equals(this.propagatingVgws())) {
            return false;
        }
        if (other.routeTableId() == null ^ this.routeTableId() == null) {
            return false;
        }
        if (other.routeTableId() != null && !other.routeTableId().equals(this.routeTableId())) {
            return false;
        }
        if (other.routes() == null ^ this.routes() == null) {
            return false;
        }
        if (other.routes() != null && !other.routes().equals(this.routes())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (associations() != null) {
            sb.append("Associations: ").append(associations()).append(",");
        }
        if (propagatingVgws() != null) {
            sb.append("PropagatingVgws: ").append(propagatingVgws()).append(",");
        }
        if (routeTableId() != null) {
            sb.append("RouteTableId: ").append(routeTableId()).append(",");
        }
        if (routes() != null) {
            sb.append("Routes: ").append(routes()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RouteTable> {
        /**
         * <p>
         * The associations between the route table and one or more subnets.
         * </p>
         * 
         * @param associations
         *        The associations between the route table and one or more subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<RouteTableAssociation> associations);

        /**
         * <p>
         * The associations between the route table and one or more subnets.
         * </p>
         * 
         * @param associations
         *        The associations between the route table and one or more subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(RouteTableAssociation... associations);

        /**
         * <p>
         * Any virtual private gateway (VGW) propagating routes.
         * </p>
         * 
         * @param propagatingVgws
         *        Any virtual private gateway (VGW) propagating routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatingVgws(Collection<PropagatingVgw> propagatingVgws);

        /**
         * <p>
         * Any virtual private gateway (VGW) propagating routes.
         * </p>
         * 
         * @param propagatingVgws
         *        Any virtual private gateway (VGW) propagating routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatingVgws(PropagatingVgw... propagatingVgws);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * The routes in the route table.
         * </p>
         * 
         * @param routes
         *        The routes in the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<Route> routes);

        /**
         * <p>
         * The routes in the route table.
         * </p>
         * 
         * @param routes
         *        The routes in the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Route... routes);

        /**
         * <p>
         * Any tags assigned to the route table.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the route table.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    private static final class BuilderImpl implements Builder {
        private List<RouteTableAssociation> associations;

        private List<PropagatingVgw> propagatingVgws;

        private String routeTableId;

        private List<Route> routes;

        private List<Tag> tags;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTable model) {
            setAssociations(model.associations);
            setPropagatingVgws(model.propagatingVgws);
            setRouteTableId(model.routeTableId);
            setRoutes(model.routes);
            setTags(model.tags);
            setVpcId(model.vpcId);
        }

        public final Collection<RouteTableAssociation> getAssociations() {
            return associations;
        }

        @Override
        public final Builder associations(Collection<RouteTableAssociation> associations) {
            this.associations = RouteTableAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(RouteTableAssociation... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        public final void setAssociations(Collection<RouteTableAssociation> associations) {
            this.associations = RouteTableAssociationListCopier.copy(associations);
        }

        @SafeVarargs
        public final void setAssociations(RouteTableAssociation... associations) {
            associations(Arrays.asList(associations));
        }

        public final Collection<PropagatingVgw> getPropagatingVgws() {
            return propagatingVgws;
        }

        @Override
        public final Builder propagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
            this.propagatingVgws = PropagatingVgwListCopier.copy(propagatingVgws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgws(PropagatingVgw... propagatingVgws) {
            propagatingVgws(Arrays.asList(propagatingVgws));
            return this;
        }

        public final void setPropagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
            this.propagatingVgws = PropagatingVgwListCopier.copy(propagatingVgws);
        }

        @SafeVarargs
        public final void setPropagatingVgws(PropagatingVgw... propagatingVgws) {
            propagatingVgws(Arrays.asList(propagatingVgws));
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final Collection<Route> getRoutes() {
            return routes;
        }

        @Override
        public final Builder routes(Collection<Route> routes) {
            this.routes = RouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Route... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        public final void setRoutes(Collection<Route> routes) {
            this.routes = RouteListCopier.copy(routes);
        }

        @SafeVarargs
        public final void setRoutes(Route... routes) {
            routes(Arrays.asList(routes));
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            tags(Arrays.asList(tags));
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public RouteTable build() {
            return new RouteTable(this);
        }
    }
}
