/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of RunScheduledInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RunScheduledInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<RunScheduledInstancesResponse.Builder, RunScheduledInstancesResponse> {
    private final List<String> instanceIdSet;

    private RunScheduledInstancesResponse(BuilderImpl builder) {
        this.instanceIdSet = builder.instanceIdSet;
    }

    /**
     * <p>
     * The IDs of the newly launched instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the newly launched instances.
     */
    public List<String> instanceIdSet() {
        return instanceIdSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceIdSet() == null) ? 0 : instanceIdSet().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunScheduledInstancesResponse)) {
            return false;
        }
        RunScheduledInstancesResponse other = (RunScheduledInstancesResponse) obj;
        if (other.instanceIdSet() == null ^ this.instanceIdSet() == null) {
            return false;
        }
        if (other.instanceIdSet() != null && !other.instanceIdSet().equals(this.instanceIdSet())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceIdSet() != null) {
            sb.append("InstanceIdSet: ").append(instanceIdSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RunScheduledInstancesResponse> {
        /**
         * <p>
         * The IDs of the newly launched instances.
         * </p>
         * 
         * @param instanceIdSet
         *        The IDs of the newly launched instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdSet(Collection<String> instanceIdSet);

        /**
         * <p>
         * The IDs of the newly launched instances.
         * </p>
         * 
         * @param instanceIdSet
         *        The IDs of the newly launched instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIdSet(String... instanceIdSet);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> instanceIdSet;

        private BuilderImpl() {
        }

        private BuilderImpl(RunScheduledInstancesResponse model) {
            setInstanceIdSet(model.instanceIdSet);
        }

        public final Collection<String> getInstanceIdSet() {
            return instanceIdSet;
        }

        @Override
        public final Builder instanceIdSet(Collection<String> instanceIdSet) {
            this.instanceIdSet = InstanceIdSetCopier.copy(instanceIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIdSet(String... instanceIdSet) {
            instanceIdSet(Arrays.asList(instanceIdSet));
            return this;
        }

        public final void setInstanceIdSet(Collection<String> instanceIdSet) {
            this.instanceIdSet = InstanceIdSetCopier.copy(instanceIdSet);
        }

        @SafeVarargs
        public final void setInstanceIdSet(String... instanceIdSet) {
            instanceIdSet(Arrays.asList(instanceIdSet));
        }

        @Override
        public RunScheduledInstancesResponse build() {
            return new RunScheduledInstancesResponse(this);
        }
    }
}
