/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network interface for a Scheduled Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduledInstancesNetworkInterface implements
        ToCopyableBuilder<ScheduledInstancesNetworkInterface.Builder, ScheduledInstancesNetworkInterface> {
    private final Boolean associatePublicIpAddress;

    private final Boolean deleteOnTermination;

    private final String description;

    private final Integer deviceIndex;

    private final List<String> groups;

    private final Integer ipv6AddressCount;

    private final List<ScheduledInstancesIpv6Address> ipv6Addresses;

    private final String networkInterfaceId;

    private final String privateIpAddress;

    private final List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs;

    private final Integer secondaryPrivateIpAddressCount;

    private final String subnetId;

    private ScheduledInstancesNetworkInterface(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.groups = builder.groups;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddressConfigs = builder.privateIpAddressConfigs;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4 address can
     * only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an
     * existing one. You cannot specify more than one network interface in the request. If launching into a default
     * subnet, the default value is <code>true</code>.
     * </p>
     * 
     * @return Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4 address
     *         can only be assigned to a network interface for eth0, and can only be assigned to a new network
     *         interface, not an existing one. You cannot specify more than one network interface in the request. If
     *         launching into a default subnet, the default value is <code>true</code>.
     */
    public Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * Indicates whether to delete the interface when the instance is terminated.
     * </p>
     * 
     * @return Indicates whether to delete the interface when the instance is terminated.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The index of the device for the network interface attachment.
     * </p>
     * 
     * @return The index of the device for the network interface attachment.
     */
    public Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * <p>
     * The IDs of one or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of one or more security groups.
     */
    public List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected
     * from the subnet range.
     * </p>
     * 
     * @return The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically
     *         selected from the subnet range.
     */
    public Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    /**
     * <p>
     * One or more specific IPv6 addresses from the subnet range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more specific IPv6 addresses from the subnet range.
     */
    public List<ScheduledInstancesIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The IPv4 address of the network interface within the subnet.
     * </p>
     * 
     * @return The IPv4 address of the network interface within the subnet.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The private IPv4 addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The private IPv4 addresses.
     */
    public List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs() {
        return privateIpAddressConfigs;
    }

    /**
     * <p>
     * The number of secondary private IPv4 addresses.
     * </p>
     * 
     * @return The number of secondary private IPv4 addresses.
     */
    public Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((associatePublicIpAddress() == null) ? 0 : associatePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + ((deleteOnTermination() == null) ? 0 : deleteOnTermination().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((deviceIndex() == null) ? 0 : deviceIndex().hashCode());
        hashCode = 31 * hashCode + ((groups() == null) ? 0 : groups().hashCode());
        hashCode = 31 * hashCode + ((ipv6AddressCount() == null) ? 0 : ipv6AddressCount().hashCode());
        hashCode = 31 * hashCode + ((ipv6Addresses() == null) ? 0 : ipv6Addresses().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaceId() == null) ? 0 : networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddress() == null) ? 0 : privateIpAddress().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddressConfigs() == null) ? 0 : privateIpAddressConfigs().hashCode());
        hashCode = 31 * hashCode + ((secondaryPrivateIpAddressCount() == null) ? 0 : secondaryPrivateIpAddressCount().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesNetworkInterface)) {
            return false;
        }
        ScheduledInstancesNetworkInterface other = (ScheduledInstancesNetworkInterface) obj;
        if (other.associatePublicIpAddress() == null ^ this.associatePublicIpAddress() == null) {
            return false;
        }
        if (other.associatePublicIpAddress() != null && !other.associatePublicIpAddress().equals(this.associatePublicIpAddress())) {
            return false;
        }
        if (other.deleteOnTermination() == null ^ this.deleteOnTermination() == null) {
            return false;
        }
        if (other.deleteOnTermination() != null && !other.deleteOnTermination().equals(this.deleteOnTermination())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.deviceIndex() == null ^ this.deviceIndex() == null) {
            return false;
        }
        if (other.deviceIndex() != null && !other.deviceIndex().equals(this.deviceIndex())) {
            return false;
        }
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.ipv6AddressCount() == null ^ this.ipv6AddressCount() == null) {
            return false;
        }
        if (other.ipv6AddressCount() != null && !other.ipv6AddressCount().equals(this.ipv6AddressCount())) {
            return false;
        }
        if (other.ipv6Addresses() == null ^ this.ipv6Addresses() == null) {
            return false;
        }
        if (other.ipv6Addresses() != null && !other.ipv6Addresses().equals(this.ipv6Addresses())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.privateIpAddressConfigs() == null ^ this.privateIpAddressConfigs() == null) {
            return false;
        }
        if (other.privateIpAddressConfigs() != null && !other.privateIpAddressConfigs().equals(this.privateIpAddressConfigs())) {
            return false;
        }
        if (other.secondaryPrivateIpAddressCount() == null ^ this.secondaryPrivateIpAddressCount() == null) {
            return false;
        }
        if (other.secondaryPrivateIpAddressCount() != null
                && !other.secondaryPrivateIpAddressCount().equals(this.secondaryPrivateIpAddressCount())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (associatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: ").append(associatePublicIpAddress()).append(",");
        }
        if (deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(deleteOnTermination()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (deviceIndex() != null) {
            sb.append("DeviceIndex: ").append(deviceIndex()).append(",");
        }
        if (groups() != null) {
            sb.append("Groups: ").append(groups()).append(",");
        }
        if (ipv6AddressCount() != null) {
            sb.append("Ipv6AddressCount: ").append(ipv6AddressCount()).append(",");
        }
        if (ipv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(ipv6Addresses()).append(",");
        }
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        if (privateIpAddressConfigs() != null) {
            sb.append("PrivateIpAddressConfigs: ").append(privateIpAddressConfigs()).append(",");
        }
        if (secondaryPrivateIpAddressCount() != null) {
            sb.append("SecondaryPrivateIpAddressCount: ").append(secondaryPrivateIpAddressCount()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduledInstancesNetworkInterface> {
        /**
         * <p>
         * Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4 address can
         * only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an
         * existing one. You cannot specify more than one network interface in the request. If launching into a default
         * subnet, the default value is <code>true</code>.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4
         *        address can only be assigned to a network interface for eth0, and can only be assigned to a new
         *        network interface, not an existing one. You cannot specify more than one network interface in the
         *        request. If launching into a default subnet, the default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * Indicates whether to delete the interface when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether to delete the interface when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The index of the device for the network interface attachment.
         * </p>
         * 
         * @param deviceIndex
         *        The index of the device for the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param groups
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param groups
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically
         * selected from the subnet range.
         * </p>
         * 
         * @param ipv6AddressCount
         *        The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically
         *        selected from the subnet range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        /**
         * <p>
         * One or more specific IPv6 addresses from the subnet range.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more specific IPv6 addresses from the subnet range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<ScheduledInstancesIpv6Address> ipv6Addresses);

        /**
         * <p>
         * One or more specific IPv6 addresses from the subnet range.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more specific IPv6 addresses from the subnet range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(ScheduledInstancesIpv6Address... ipv6Addresses);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The IPv4 address of the network interface within the subnet.
         * </p>
         * 
         * @param privateIpAddress
         *        The IPv4 address of the network interface within the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The private IPv4 addresses.
         * </p>
         * 
         * @param privateIpAddressConfigs
         *        The private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs);

        /**
         * <p>
         * The private IPv4 addresses.
         * </p>
         * 
         * @param privateIpAddressConfigs
         *        The private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddressConfigs(ScheduledInstancesPrivateIpAddressConfig... privateIpAddressConfigs);

        /**
         * <p>
         * The number of secondary private IPv4 addresses.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        The number of secondary private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean associatePublicIpAddress;

        private Boolean deleteOnTermination;

        private String description;

        private Integer deviceIndex;

        private List<String> groups;

        private Integer ipv6AddressCount;

        private List<ScheduledInstancesIpv6Address> ipv6Addresses;

        private String networkInterfaceId;

        private String privateIpAddress;

        private List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs;

        private Integer secondaryPrivateIpAddressCount;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesNetworkInterface model) {
            setAssociatePublicIpAddress(model.associatePublicIpAddress);
            setDeleteOnTermination(model.deleteOnTermination);
            setDescription(model.description);
            setDeviceIndex(model.deviceIndex);
            setGroups(model.groups);
            setIpv6AddressCount(model.ipv6AddressCount);
            setIpv6Addresses(model.ipv6Addresses);
            setNetworkInterfaceId(model.networkInterfaceId);
            setPrivateIpAddress(model.privateIpAddress);
            setPrivateIpAddressConfigs(model.privateIpAddressConfigs);
            setSecondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            setSubnetId(model.subnetId);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final Collection<String> getGroups() {
            return groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ScheduledInstancesSecurityGroupIdSetCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ScheduledInstancesSecurityGroupIdSetCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(String... groups) {
            groups(Arrays.asList(groups));
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        public final Collection<ScheduledInstancesIpv6Address> getIpv6Addresses() {
            return ipv6Addresses;
        }

        @Override
        public final Builder ipv6Addresses(Collection<ScheduledInstancesIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = ScheduledInstancesIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(ScheduledInstancesIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<ScheduledInstancesIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = ScheduledInstancesIpv6AddressListCopier.copy(ipv6Addresses);
        }

        @SafeVarargs
        public final void setIpv6Addresses(ScheduledInstancesIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<ScheduledInstancesPrivateIpAddressConfig> getPrivateIpAddressConfigs() {
            return privateIpAddressConfigs;
        }

        @Override
        public final Builder privateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs) {
            this.privateIpAddressConfigs = PrivateIpAddressConfigSetCopier.copy(privateIpAddressConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddressConfigs(ScheduledInstancesPrivateIpAddressConfig... privateIpAddressConfigs) {
            privateIpAddressConfigs(Arrays.asList(privateIpAddressConfigs));
            return this;
        }

        public final void setPrivateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs) {
            this.privateIpAddressConfigs = PrivateIpAddressConfigSetCopier.copy(privateIpAddressConfigs);
        }

        @SafeVarargs
        public final void setPrivateIpAddressConfigs(ScheduledInstancesPrivateIpAddressConfig... privateIpAddressConfigs) {
            privateIpAddressConfigs(Arrays.asList(privateIpAddressConfigs));
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public ScheduledInstancesNetworkInterface build() {
            return new ScheduledInstancesNetworkInterface(this);
        }
    }
}
