/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a private IPv4 address for a Scheduled Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduledInstancesPrivateIpAddressConfig implements
        ToCopyableBuilder<ScheduledInstancesPrivateIpAddressConfig.Builder, ScheduledInstancesPrivateIpAddressConfig> {
    private final Boolean primary;

    private final String privateIpAddress;

    private ScheduledInstancesPrivateIpAddressConfig(BuilderImpl builder) {
        this.primary = builder.primary;
        this.privateIpAddress = builder.privateIpAddress;
    }

    /**
     * <p>
     * Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.
     * </p>
     * 
     * @return Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.
     */
    public Boolean primary() {
        return primary;
    }

    /**
     * <p>
     * The IPv4 address.
     * </p>
     * 
     * @return The IPv4 address.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((primary() == null) ? 0 : primary().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddress() == null) ? 0 : privateIpAddress().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesPrivateIpAddressConfig)) {
            return false;
        }
        ScheduledInstancesPrivateIpAddressConfig other = (ScheduledInstancesPrivateIpAddressConfig) obj;
        if (other.primary() == null ^ this.primary() == null) {
            return false;
        }
        if (other.primary() != null && !other.primary().equals(this.primary())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (primary() != null) {
            sb.append("Primary: ").append(primary()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduledInstancesPrivateIpAddressConfig> {
        /**
         * <p>
         * Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.
         * </p>
         * 
         * @param primary
         *        Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Boolean primary);

        /**
         * <p>
         * The IPv4 address.
         * </p>
         * 
         * @param privateIpAddress
         *        The IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean primary;

        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesPrivateIpAddressConfig model) {
            setPrimary(model.primary);
            setPrivateIpAddress(model.privateIpAddress);
        }

        public final Boolean getPrimary() {
            return primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public ScheduledInstancesPrivateIpAddressConfig build() {
            return new ScheduledInstancesPrivateIpAddressConfig(this);
        }
    }
}
