/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes Spot instance placement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SpotPlacement implements ToCopyableBuilder<SpotPlacement.Builder, SpotPlacement> {
    private final String availabilityZone;

    private final String groupName;

    private final String tenancy;

    private SpotPlacement(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.groupName = builder.groupName;
        this.tenancy = builder.tenancy;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * <p>
     * [Spot fleet only] To specify multiple Availability Zones, separate them using commas; for example,
     * "us-west-2a, us-west-2b".
     * </p>
     * 
     * @return The Availability Zone.</p>
     *         <p>
     *         [Spot fleet only] To specify multiple Availability Zones, separate them using commas; for example,
     *         "us-west-2a, us-west-2b".
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The name of the placement group (for cluster instances).
     * </p>
     * 
     * @return The name of the placement group (for cluster instances).
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for Spot
     * instances.
     * </p>
     * 
     * @return The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     *         <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for
     *         Spot instances.
     * @see Tenancy
     */
    public String tenancy() {
        return tenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((groupName() == null) ? 0 : groupName().hashCode());
        hashCode = 31 * hashCode + ((tenancy() == null) ? 0 : tenancy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotPlacement)) {
            return false;
        }
        SpotPlacement other = (SpotPlacement) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.tenancy() == null ^ this.tenancy() == null) {
            return false;
        }
        if (other.tenancy() != null && !other.tenancy().equals(this.tenancy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (tenancy() != null) {
            sb.append("Tenancy: ").append(tenancy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SpotPlacement> {
        /**
         * <p>
         * The Availability Zone.
         * </p>
         * <p>
         * [Spot fleet only] To specify multiple Availability Zones, separate them using commas; for example,
         * "us-west-2a, us-west-2b".
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.</p>
         *        <p>
         *        [Spot fleet only] To specify multiple Availability Zones, separate them using commas; for example,
         *        "us-west-2a, us-west-2b".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The name of the placement group (for cluster instances).
         * </p>
         * 
         * @param groupName
         *        The name of the placement group (for cluster instances).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for
         * Spot instances.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         *        <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported
         *        for Spot instances.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for
         * Spot instances.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         *        <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported
         *        for Spot instances.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(Tenancy tenancy);
    }

    private static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String groupName;

        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotPlacement model) {
            setAvailabilityZone(model.availabilityZone);
            setGroupName(model.groupName);
            setTenancy(model.tenancy);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getTenancy() {
            return tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final void setTenancy(Tenancy tenancy) {
            this.tenancy(tenancy.toString());
        }

        @Override
        public SpotPlacement build() {
            return new SpotPlacement(this);
        }
    }
}
