/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the state of a CIDR block.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SubnetCidrBlockState implements ToCopyableBuilder<SubnetCidrBlockState.Builder, SubnetCidrBlockState> {
    private final String state;

    private final String statusMessage;

    private SubnetCidrBlockState(BuilderImpl builder) {
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The state of a CIDR block.
     * </p>
     * 
     * @return The state of a CIDR block.
     * @see SubnetCidrBlockStateCode
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * A message about the status of the CIDR block, if applicable.
     * </p>
     * 
     * @return A message about the status of the CIDR block, if applicable.
     */
    public String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((statusMessage() == null) ? 0 : statusMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetCidrBlockState)) {
            return false;
        }
        SubnetCidrBlockState other = (SubnetCidrBlockState) obj;
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (statusMessage() != null) {
            sb.append("StatusMessage: ").append(statusMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SubnetCidrBlockState> {
        /**
         * <p>
         * The state of a CIDR block.
         * </p>
         * 
         * @param state
         *        The state of a CIDR block.
         * @see SubnetCidrBlockStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubnetCidrBlockStateCode
         */
        Builder state(String state);

        /**
         * <p>
         * The state of a CIDR block.
         * </p>
         * 
         * @param state
         *        The state of a CIDR block.
         * @see SubnetCidrBlockStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubnetCidrBlockStateCode
         */
        Builder state(SubnetCidrBlockStateCode state);

        /**
         * <p>
         * A message about the status of the CIDR block, if applicable.
         * </p>
         * 
         * @param statusMessage
         *        A message about the status of the CIDR block, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    private static final class BuilderImpl implements Builder {
        private String state;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetCidrBlockState model) {
            setState(model.state);
            setStatusMessage(model.statusMessage);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SubnetCidrBlockStateCode state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(SubnetCidrBlockStateCode state) {
            this.state(state.toString());
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public SubnetCidrBlockState build() {
            return new SubnetCidrBlockState(this);
        }
    }
}
