/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPv6 CIDR block associated with a subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SubnetIpv6CidrBlockAssociation implements
        ToCopyableBuilder<SubnetIpv6CidrBlockAssociation.Builder, SubnetIpv6CidrBlockAssociation> {
    private final String associationId;

    private final String ipv6CidrBlock;

    private final SubnetCidrBlockState ipv6CidrBlockState;

    private SubnetIpv6CidrBlockAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.ipv6CidrBlockState = builder.ipv6CidrBlockState;
    }

    /**
     * <p>
     * The association ID for the CIDR block.
     * </p>
     * 
     * @return The association ID for the CIDR block.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The IPv6 CIDR block.
     * </p>
     * 
     * @return The IPv6 CIDR block.
     */
    public String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * Information about the state of the CIDR block.
     * </p>
     * 
     * @return Information about the state of the CIDR block.
     */
    public SubnetCidrBlockState ipv6CidrBlockState() {
        return ipv6CidrBlockState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((associationId() == null) ? 0 : associationId().hashCode());
        hashCode = 31 * hashCode + ((ipv6CidrBlock() == null) ? 0 : ipv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + ((ipv6CidrBlockState() == null) ? 0 : ipv6CidrBlockState().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetIpv6CidrBlockAssociation)) {
            return false;
        }
        SubnetIpv6CidrBlockAssociation other = (SubnetIpv6CidrBlockAssociation) obj;
        if (other.associationId() == null ^ this.associationId() == null) {
            return false;
        }
        if (other.associationId() != null && !other.associationId().equals(this.associationId())) {
            return false;
        }
        if (other.ipv6CidrBlock() == null ^ this.ipv6CidrBlock() == null) {
            return false;
        }
        if (other.ipv6CidrBlock() != null && !other.ipv6CidrBlock().equals(this.ipv6CidrBlock())) {
            return false;
        }
        if (other.ipv6CidrBlockState() == null ^ this.ipv6CidrBlockState() == null) {
            return false;
        }
        if (other.ipv6CidrBlockState() != null && !other.ipv6CidrBlockState().equals(this.ipv6CidrBlockState())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (associationId() != null) {
            sb.append("AssociationId: ").append(associationId()).append(",");
        }
        if (ipv6CidrBlock() != null) {
            sb.append("Ipv6CidrBlock: ").append(ipv6CidrBlock()).append(",");
        }
        if (ipv6CidrBlockState() != null) {
            sb.append("Ipv6CidrBlockState: ").append(ipv6CidrBlockState()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SubnetIpv6CidrBlockAssociation> {
        /**
         * <p>
         * The association ID for the CIDR block.
         * </p>
         * 
         * @param associationId
         *        The association ID for the CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The IPv6 CIDR block.
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * Information about the state of the CIDR block.
         * </p>
         * 
         * @param ipv6CidrBlockState
         *        Information about the state of the CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockState(SubnetCidrBlockState ipv6CidrBlockState);
    }

    private static final class BuilderImpl implements Builder {
        private String associationId;

        private String ipv6CidrBlock;

        private SubnetCidrBlockState ipv6CidrBlockState;

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetIpv6CidrBlockAssociation model) {
            setAssociationId(model.associationId);
            setIpv6CidrBlock(model.ipv6CidrBlock);
            setIpv6CidrBlockState(model.ipv6CidrBlockState);
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final SubnetCidrBlockState getIpv6CidrBlockState() {
            return ipv6CidrBlockState;
        }

        @Override
        public final Builder ipv6CidrBlockState(SubnetCidrBlockState ipv6CidrBlockState) {
            this.ipv6CidrBlockState = ipv6CidrBlockState;
            return this;
        }

        public final void setIpv6CidrBlockState(SubnetCidrBlockState ipv6CidrBlockState) {
            this.ipv6CidrBlockState = ipv6CidrBlockState;
        }

        @Override
        public SubnetIpv6CidrBlockAssociation build() {
            return new SubnetIpv6CidrBlockAssociation(this);
        }
    }
}
