/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a security group and AWS account ID pair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UserIdGroupPair implements ToCopyableBuilder<UserIdGroupPair.Builder, UserIdGroupPair> {
    private final String groupId;

    private final String groupName;

    private final String peeringStatus;

    private final String userId;

    private final String vpcId;

    private final String vpcPeeringConnectionId;

    private UserIdGroupPair(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.peeringStatus = builder.peeringStatus;
        this.userId = builder.userId;
        this.vpcId = builder.vpcId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The name of the security group. In a request, use this parameter for a security group in EC2-Classic or a default
     * VPC only. For a security group in a nondefault VPC, use the security group ID.
     * </p>
     * 
     * @return The name of the security group. In a request, use this parameter for a security group in EC2-Classic or a
     *         default VPC only. For a security group in a nondefault VPC, use the security group ID.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The status of a VPC peering connection, if applicable.
     * </p>
     * 
     * @return The status of a VPC peering connection, if applicable.
     */
    public String peeringStatus() {
        return peeringStatus;
    }

    /**
     * <p>
     * The ID of an AWS account. For a referenced security group in another VPC, the account ID of the referenced
     * security group is returned.
     * </p>
     * <p>
     * [EC2-Classic] Required when adding or removing rules that reference a security group in another AWS account.
     * </p>
     * 
     * @return The ID of an AWS account. For a referenced security group in another VPC, the account ID of the
     *         referenced security group is returned.</p>
     *         <p>
     *         [EC2-Classic] Required when adding or removing rules that reference a security group in another AWS
     *         account.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The ID of the VPC for the referenced security group, if applicable.
     * </p>
     * 
     * @return The ID of the VPC for the referenced security group, if applicable.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The ID of the VPC peering connection, if applicable.
     * </p>
     * 
     * @return The ID of the VPC peering connection, if applicable.
     */
    public String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((groupId() == null) ? 0 : groupId().hashCode());
        hashCode = 31 * hashCode + ((groupName() == null) ? 0 : groupName().hashCode());
        hashCode = 31 * hashCode + ((peeringStatus() == null) ? 0 : peeringStatus().hashCode());
        hashCode = 31 * hashCode + ((userId() == null) ? 0 : userId().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        hashCode = 31 * hashCode + ((vpcPeeringConnectionId() == null) ? 0 : vpcPeeringConnectionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdGroupPair)) {
            return false;
        }
        UserIdGroupPair other = (UserIdGroupPair) obj;
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        if (other.groupId() != null && !other.groupId().equals(this.groupId())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.peeringStatus() == null ^ this.peeringStatus() == null) {
            return false;
        }
        if (other.peeringStatus() != null && !other.peeringStatus().equals(this.peeringStatus())) {
            return false;
        }
        if (other.userId() == null ^ this.userId() == null) {
            return false;
        }
        if (other.userId() != null && !other.userId().equals(this.userId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.vpcPeeringConnectionId() == null ^ this.vpcPeeringConnectionId() == null) {
            return false;
        }
        if (other.vpcPeeringConnectionId() != null && !other.vpcPeeringConnectionId().equals(this.vpcPeeringConnectionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (groupId() != null) {
            sb.append("GroupId: ").append(groupId()).append(",");
        }
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (peeringStatus() != null) {
            sb.append("PeeringStatus: ").append(peeringStatus()).append(",");
        }
        if (userId() != null) {
            sb.append("UserId: ").append(userId()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (vpcPeeringConnectionId() != null) {
            sb.append("VpcPeeringConnectionId: ").append(vpcPeeringConnectionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UserIdGroupPair> {
        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The name of the security group. In a request, use this parameter for a security group in EC2-Classic or a
         * default VPC only. For a security group in a nondefault VPC, use the security group ID.
         * </p>
         * 
         * @param groupName
         *        The name of the security group. In a request, use this parameter for a security group in EC2-Classic
         *        or a default VPC only. For a security group in a nondefault VPC, use the security group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The status of a VPC peering connection, if applicable.
         * </p>
         * 
         * @param peeringStatus
         *        The status of a VPC peering connection, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeringStatus(String peeringStatus);

        /**
         * <p>
         * The ID of an AWS account. For a referenced security group in another VPC, the account ID of the referenced
         * security group is returned.
         * </p>
         * <p>
         * [EC2-Classic] Required when adding or removing rules that reference a security group in another AWS account.
         * </p>
         * 
         * @param userId
         *        The ID of an AWS account. For a referenced security group in another VPC, the account ID of the
         *        referenced security group is returned.</p>
         *        <p>
         *        [EC2-Classic] Required when adding or removing rules that reference a security group in another AWS
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The ID of the VPC for the referenced security group, if applicable.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the referenced security group, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The ID of the VPC peering connection, if applicable.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    private static final class BuilderImpl implements Builder {
        private String groupId;

        private String groupName;

        private String peeringStatus;

        private String userId;

        private String vpcId;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UserIdGroupPair model) {
            setGroupId(model.groupId);
            setGroupName(model.groupName);
            setPeeringStatus(model.peeringStatus);
            setUserId(model.userId);
            setVpcId(model.vpcId);
            setVpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getPeeringStatus() {
            return peeringStatus;
        }

        @Override
        public final Builder peeringStatus(String peeringStatus) {
            this.peeringStatus = peeringStatus;
            return this;
        }

        public final void setPeeringStatus(String peeringStatus) {
            this.peeringStatus = peeringStatus;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public UserIdGroupPair build() {
            return new UserIdGroupPair(this);
        }
    }
}
