/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the modification status of an EBS volume.
 * </p>
 * <p>
 * If the volume has never been modified, some element values will be null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeModification implements ToCopyableBuilder<VolumeModification.Builder, VolumeModification> {
    private final String volumeId;

    private final String modificationState;

    private final String statusMessage;

    private final Integer targetSize;

    private final Integer targetIops;

    private final String targetVolumeType;

    private final Integer originalSize;

    private final Integer originalIops;

    private final String originalVolumeType;

    private final Long progress;

    private final Instant startTime;

    private final Instant endTime;

    private VolumeModification(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.modificationState = builder.modificationState;
        this.statusMessage = builder.statusMessage;
        this.targetSize = builder.targetSize;
        this.targetIops = builder.targetIops;
        this.targetVolumeType = builder.targetVolumeType;
        this.originalSize = builder.originalSize;
        this.originalIops = builder.originalIops;
        this.originalVolumeType = builder.originalVolumeType;
        this.progress = builder.progress;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * ID of the volume being modified.
     * </p>
     * 
     * @return ID of the volume being modified.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * Current state of modification. Modification state is null for unmodified volumes.
     * </p>
     * 
     * @return Current state of modification. Modification state is null for unmodified volumes.
     * @see VolumeModificationState
     */
    public String modificationState() {
        return modificationState;
    }

    /**
     * <p>
     * Generic status message on modification progress or failure.
     * </p>
     * 
     * @return Generic status message on modification progress or failure.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Target size of the volume being modified.
     * </p>
     * 
     * @return Target size of the volume being modified.
     */
    public Integer targetSize() {
        return targetSize;
    }

    /**
     * <p>
     * Target IOPS rate of the volume being modified.
     * </p>
     * 
     * @return Target IOPS rate of the volume being modified.
     */
    public Integer targetIops() {
        return targetIops;
    }

    /**
     * <p>
     * Target EBS volume type of the volume being modified.
     * </p>
     * 
     * @return Target EBS volume type of the volume being modified.
     * @see VolumeType
     */
    public String targetVolumeType() {
        return targetVolumeType;
    }

    /**
     * <p>
     * Original size of the volume being modified.
     * </p>
     * 
     * @return Original size of the volume being modified.
     */
    public Integer originalSize() {
        return originalSize;
    }

    /**
     * <p>
     * Original IOPS rate of the volume being modified.
     * </p>
     * 
     * @return Original IOPS rate of the volume being modified.
     */
    public Integer originalIops() {
        return originalIops;
    }

    /**
     * <p>
     * Original EBS volume type of the volume being modified.
     * </p>
     * 
     * @return Original EBS volume type of the volume being modified.
     * @see VolumeType
     */
    public String originalVolumeType() {
        return originalVolumeType;
    }

    /**
     * <p>
     * Modification progress from 0 to 100%.
     * </p>
     * 
     * @return Modification progress from 0 to 100%.
     */
    public Long progress() {
        return progress;
    }

    /**
     * <p>
     * Modification start time
     * </p>
     * 
     * @return Modification start time
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Modification completion or failure time.
     * </p>
     * 
     * @return Modification completion or failure time.
     */
    public Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((volumeId() == null) ? 0 : volumeId().hashCode());
        hashCode = 31 * hashCode + ((modificationState() == null) ? 0 : modificationState().hashCode());
        hashCode = 31 * hashCode + ((statusMessage() == null) ? 0 : statusMessage().hashCode());
        hashCode = 31 * hashCode + ((targetSize() == null) ? 0 : targetSize().hashCode());
        hashCode = 31 * hashCode + ((targetIops() == null) ? 0 : targetIops().hashCode());
        hashCode = 31 * hashCode + ((targetVolumeType() == null) ? 0 : targetVolumeType().hashCode());
        hashCode = 31 * hashCode + ((originalSize() == null) ? 0 : originalSize().hashCode());
        hashCode = 31 * hashCode + ((originalIops() == null) ? 0 : originalIops().hashCode());
        hashCode = 31 * hashCode + ((originalVolumeType() == null) ? 0 : originalVolumeType().hashCode());
        hashCode = 31 * hashCode + ((progress() == null) ? 0 : progress().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeModification)) {
            return false;
        }
        VolumeModification other = (VolumeModification) obj;
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        if (other.modificationState() == null ^ this.modificationState() == null) {
            return false;
        }
        if (other.modificationState() != null && !other.modificationState().equals(this.modificationState())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.targetSize() == null ^ this.targetSize() == null) {
            return false;
        }
        if (other.targetSize() != null && !other.targetSize().equals(this.targetSize())) {
            return false;
        }
        if (other.targetIops() == null ^ this.targetIops() == null) {
            return false;
        }
        if (other.targetIops() != null && !other.targetIops().equals(this.targetIops())) {
            return false;
        }
        if (other.targetVolumeType() == null ^ this.targetVolumeType() == null) {
            return false;
        }
        if (other.targetVolumeType() != null && !other.targetVolumeType().equals(this.targetVolumeType())) {
            return false;
        }
        if (other.originalSize() == null ^ this.originalSize() == null) {
            return false;
        }
        if (other.originalSize() != null && !other.originalSize().equals(this.originalSize())) {
            return false;
        }
        if (other.originalIops() == null ^ this.originalIops() == null) {
            return false;
        }
        if (other.originalIops() != null && !other.originalIops().equals(this.originalIops())) {
            return false;
        }
        if (other.originalVolumeType() == null ^ this.originalVolumeType() == null) {
            return false;
        }
        if (other.originalVolumeType() != null && !other.originalVolumeType().equals(this.originalVolumeType())) {
            return false;
        }
        if (other.progress() == null ^ this.progress() == null) {
            return false;
        }
        if (other.progress() != null && !other.progress().equals(this.progress())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (volumeId() != null) {
            sb.append("VolumeId: ").append(volumeId()).append(",");
        }
        if (modificationState() != null) {
            sb.append("ModificationState: ").append(modificationState()).append(",");
        }
        if (statusMessage() != null) {
            sb.append("StatusMessage: ").append(statusMessage()).append(",");
        }
        if (targetSize() != null) {
            sb.append("TargetSize: ").append(targetSize()).append(",");
        }
        if (targetIops() != null) {
            sb.append("TargetIops: ").append(targetIops()).append(",");
        }
        if (targetVolumeType() != null) {
            sb.append("TargetVolumeType: ").append(targetVolumeType()).append(",");
        }
        if (originalSize() != null) {
            sb.append("OriginalSize: ").append(originalSize()).append(",");
        }
        if (originalIops() != null) {
            sb.append("OriginalIops: ").append(originalIops()).append(",");
        }
        if (originalVolumeType() != null) {
            sb.append("OriginalVolumeType: ").append(originalVolumeType()).append(",");
        }
        if (progress() != null) {
            sb.append("Progress: ").append(progress()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeModification> {
        /**
         * <p>
         * ID of the volume being modified.
         * </p>
         * 
         * @param volumeId
         *        ID of the volume being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * Current state of modification. Modification state is null for unmodified volumes.
         * </p>
         * 
         * @param modificationState
         *        Current state of modification. Modification state is null for unmodified volumes.
         * @see VolumeModificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeModificationState
         */
        Builder modificationState(String modificationState);

        /**
         * <p>
         * Current state of modification. Modification state is null for unmodified volumes.
         * </p>
         * 
         * @param modificationState
         *        Current state of modification. Modification state is null for unmodified volumes.
         * @see VolumeModificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeModificationState
         */
        Builder modificationState(VolumeModificationState modificationState);

        /**
         * <p>
         * Generic status message on modification progress or failure.
         * </p>
         * 
         * @param statusMessage
         *        Generic status message on modification progress or failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Target size of the volume being modified.
         * </p>
         * 
         * @param targetSize
         *        Target size of the volume being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSize(Integer targetSize);

        /**
         * <p>
         * Target IOPS rate of the volume being modified.
         * </p>
         * 
         * @param targetIops
         *        Target IOPS rate of the volume being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIops(Integer targetIops);

        /**
         * <p>
         * Target EBS volume type of the volume being modified.
         * </p>
         * 
         * @param targetVolumeType
         *        Target EBS volume type of the volume being modified.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder targetVolumeType(String targetVolumeType);

        /**
         * <p>
         * Target EBS volume type of the volume being modified.
         * </p>
         * 
         * @param targetVolumeType
         *        Target EBS volume type of the volume being modified.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder targetVolumeType(VolumeType targetVolumeType);

        /**
         * <p>
         * Original size of the volume being modified.
         * </p>
         * 
         * @param originalSize
         *        Original size of the volume being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalSize(Integer originalSize);

        /**
         * <p>
         * Original IOPS rate of the volume being modified.
         * </p>
         * 
         * @param originalIops
         *        Original IOPS rate of the volume being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalIops(Integer originalIops);

        /**
         * <p>
         * Original EBS volume type of the volume being modified.
         * </p>
         * 
         * @param originalVolumeType
         *        Original EBS volume type of the volume being modified.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder originalVolumeType(String originalVolumeType);

        /**
         * <p>
         * Original EBS volume type of the volume being modified.
         * </p>
         * 
         * @param originalVolumeType
         *        Original EBS volume type of the volume being modified.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder originalVolumeType(VolumeType originalVolumeType);

        /**
         * <p>
         * Modification progress from 0 to 100%.
         * </p>
         * 
         * @param progress
         *        Modification progress from 0 to 100%.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(Long progress);

        /**
         * <p>
         * Modification start time
         * </p>
         * 
         * @param startTime
         *        Modification start time
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Modification completion or failure time.
         * </p>
         * 
         * @param endTime
         *        Modification completion or failure time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    private static final class BuilderImpl implements Builder {
        private String volumeId;

        private String modificationState;

        private String statusMessage;

        private Integer targetSize;

        private Integer targetIops;

        private String targetVolumeType;

        private Integer originalSize;

        private Integer originalIops;

        private String originalVolumeType;

        private Long progress;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeModification model) {
            setVolumeId(model.volumeId);
            setModificationState(model.modificationState);
            setStatusMessage(model.statusMessage);
            setTargetSize(model.targetSize);
            setTargetIops(model.targetIops);
            setTargetVolumeType(model.targetVolumeType);
            setOriginalSize(model.originalSize);
            setOriginalIops(model.originalIops);
            setOriginalVolumeType(model.originalVolumeType);
            setProgress(model.progress);
            setStartTime(model.startTime);
            setEndTime(model.endTime);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final String getModificationState() {
            return modificationState;
        }

        @Override
        public final Builder modificationState(String modificationState) {
            this.modificationState = modificationState;
            return this;
        }

        @Override
        public final Builder modificationState(VolumeModificationState modificationState) {
            this.modificationState(modificationState.toString());
            return this;
        }

        public final void setModificationState(String modificationState) {
            this.modificationState = modificationState;
        }

        public final void setModificationState(VolumeModificationState modificationState) {
            this.modificationState(modificationState.toString());
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Integer getTargetSize() {
            return targetSize;
        }

        @Override
        public final Builder targetSize(Integer targetSize) {
            this.targetSize = targetSize;
            return this;
        }

        public final void setTargetSize(Integer targetSize) {
            this.targetSize = targetSize;
        }

        public final Integer getTargetIops() {
            return targetIops;
        }

        @Override
        public final Builder targetIops(Integer targetIops) {
            this.targetIops = targetIops;
            return this;
        }

        public final void setTargetIops(Integer targetIops) {
            this.targetIops = targetIops;
        }

        public final String getTargetVolumeType() {
            return targetVolumeType;
        }

        @Override
        public final Builder targetVolumeType(String targetVolumeType) {
            this.targetVolumeType = targetVolumeType;
            return this;
        }

        @Override
        public final Builder targetVolumeType(VolumeType targetVolumeType) {
            this.targetVolumeType(targetVolumeType.toString());
            return this;
        }

        public final void setTargetVolumeType(String targetVolumeType) {
            this.targetVolumeType = targetVolumeType;
        }

        public final void setTargetVolumeType(VolumeType targetVolumeType) {
            this.targetVolumeType(targetVolumeType.toString());
        }

        public final Integer getOriginalSize() {
            return originalSize;
        }

        @Override
        public final Builder originalSize(Integer originalSize) {
            this.originalSize = originalSize;
            return this;
        }

        public final void setOriginalSize(Integer originalSize) {
            this.originalSize = originalSize;
        }

        public final Integer getOriginalIops() {
            return originalIops;
        }

        @Override
        public final Builder originalIops(Integer originalIops) {
            this.originalIops = originalIops;
            return this;
        }

        public final void setOriginalIops(Integer originalIops) {
            this.originalIops = originalIops;
        }

        public final String getOriginalVolumeType() {
            return originalVolumeType;
        }

        @Override
        public final Builder originalVolumeType(String originalVolumeType) {
            this.originalVolumeType = originalVolumeType;
            return this;
        }

        @Override
        public final Builder originalVolumeType(VolumeType originalVolumeType) {
            this.originalVolumeType(originalVolumeType.toString());
            return this;
        }

        public final void setOriginalVolumeType(String originalVolumeType) {
            this.originalVolumeType = originalVolumeType;
        }

        public final void setOriginalVolumeType(VolumeType originalVolumeType) {
            this.originalVolumeType(originalVolumeType.toString());
        }

        public final Long getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(Long progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(Long progress) {
            this.progress = progress;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public VolumeModification build() {
            return new VolumeModification(this);
        }
    }
}
