/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a virtual private gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpnGateway implements ToCopyableBuilder<VpnGateway.Builder, VpnGateway> {
    private final String availabilityZone;

    private final String state;

    private final String type;

    private final List<VpcAttachment> vpcAttachments;

    private final String vpnGatewayId;

    private final List<Tag> tags;

    private VpnGateway(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.state = builder.state;
        this.type = builder.type;
        this.vpcAttachments = builder.vpcAttachments;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Availability Zone where the virtual private gateway was created, if applicable. This field may be empty or
     * not returned.
     * </p>
     * 
     * @return The Availability Zone where the virtual private gateway was created, if applicable. This field may be
     *         empty or not returned.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The current state of the virtual private gateway.
     * </p>
     * 
     * @return The current state of the virtual private gateway.
     * @see VpnState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The type of VPN connection the virtual private gateway supports.
     * </p>
     * 
     * @return The type of VPN connection the virtual private gateway supports.
     * @see GatewayType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * Any VPCs attached to the virtual private gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any VPCs attached to the virtual private gateway.
     */
    public List<VpcAttachment> vpcAttachments() {
        return vpcAttachments;
    }

    /**
     * <p>
     * The ID of the virtual private gateway.
     * </p>
     * 
     * @return The ID of the virtual private gateway.
     */
    public String vpnGatewayId() {
        return vpnGatewayId;
    }

    /**
     * <p>
     * Any tags assigned to the virtual private gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the virtual private gateway.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((vpcAttachments() == null) ? 0 : vpcAttachments().hashCode());
        hashCode = 31 * hashCode + ((vpnGatewayId() == null) ? 0 : vpnGatewayId().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnGateway)) {
            return false;
        }
        VpnGateway other = (VpnGateway) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.vpcAttachments() == null ^ this.vpcAttachments() == null) {
            return false;
        }
        if (other.vpcAttachments() != null && !other.vpcAttachments().equals(this.vpcAttachments())) {
            return false;
        }
        if (other.vpnGatewayId() == null ^ this.vpnGatewayId() == null) {
            return false;
        }
        if (other.vpnGatewayId() != null && !other.vpnGatewayId().equals(this.vpnGatewayId())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (vpcAttachments() != null) {
            sb.append("VpcAttachments: ").append(vpcAttachments()).append(",");
        }
        if (vpnGatewayId() != null) {
            sb.append("VpnGatewayId: ").append(vpnGatewayId()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VpnGateway> {
        /**
         * <p>
         * The Availability Zone where the virtual private gateway was created, if applicable. This field may be empty
         * or not returned.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where the virtual private gateway was created, if applicable. This field may be
         *        empty or not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The current state of the virtual private gateway.
         * </p>
         * 
         * @param state
         *        The current state of the virtual private gateway.
         * @see VpnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the virtual private gateway.
         * </p>
         * 
         * @param state
         *        The current state of the virtual private gateway.
         * @see VpnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnState
         */
        Builder state(VpnState state);

        /**
         * <p>
         * The type of VPN connection the virtual private gateway supports.
         * </p>
         * 
         * @param type
         *        The type of VPN connection the virtual private gateway supports.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of VPN connection the virtual private gateway supports.
         * </p>
         * 
         * @param type
         *        The type of VPN connection the virtual private gateway supports.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(GatewayType type);

        /**
         * <p>
         * Any VPCs attached to the virtual private gateway.
         * </p>
         * 
         * @param vpcAttachments
         *        Any VPCs attached to the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcAttachments(Collection<VpcAttachment> vpcAttachments);

        /**
         * <p>
         * Any VPCs attached to the virtual private gateway.
         * </p>
         * 
         * @param vpcAttachments
         *        Any VPCs attached to the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcAttachments(VpcAttachment... vpcAttachments);

        /**
         * <p>
         * The ID of the virtual private gateway.
         * </p>
         * 
         * @param vpnGatewayId
         *        The ID of the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGatewayId(String vpnGatewayId);

        /**
         * <p>
         * Any tags assigned to the virtual private gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the virtual private gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    private static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String state;

        private String type;

        private List<VpcAttachment> vpcAttachments;

        private String vpnGatewayId;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnGateway model) {
            setAvailabilityZone(model.availabilityZone);
            setState(model.state);
            setType(model.type);
            setVpcAttachments(model.vpcAttachments);
            setVpnGatewayId(model.vpnGatewayId);
            setTags(model.tags);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(VpnState state) {
            this.state(state.toString());
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(GatewayType type) {
            this.type(type.toString());
        }

        public final Collection<VpcAttachment> getVpcAttachments() {
            return vpcAttachments;
        }

        @Override
        public final Builder vpcAttachments(Collection<VpcAttachment> vpcAttachments) {
            this.vpcAttachments = VpcAttachmentListCopier.copy(vpcAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcAttachments(VpcAttachment... vpcAttachments) {
            vpcAttachments(Arrays.asList(vpcAttachments));
            return this;
        }

        public final void setVpcAttachments(Collection<VpcAttachment> vpcAttachments) {
            this.vpcAttachments = VpcAttachmentListCopier.copy(vpcAttachments);
        }

        @SafeVarargs
        public final void setVpcAttachments(VpcAttachment... vpcAttachments) {
            vpcAttachments(Arrays.asList(vpcAttachments));
        }

        public final String getVpnGatewayId() {
            return vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            tags(Arrays.asList(tags));
        }

        @Override
        public VpnGateway build() {
            return new VpnGateway(this);
        }
    }
}
