/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * AssignIpv6AddressesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AssignIpv6AddressesResponseUnmarshaller implements
        Unmarshaller<AssignIpv6AddressesResponse, StaxUnmarshallerContext> {

    public AssignIpv6AddressesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        AssignIpv6AddressesResponse.Builder assignIpv6AddressesResponse = AssignIpv6AddressesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> assignedIpv6Addresses = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                assignIpv6AddressesResponse.assignedIpv6Addresses(assignedIpv6Addresses);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("assignedIpv6Addresses", targetDepth)) {
                    assignedIpv6Addresses = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("assignedIpv6Addresses/item", targetDepth)) {
                    assignedIpv6Addresses.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkInterfaceId", targetDepth)) {
                    assignIpv6AddressesResponse.networkInterfaceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    assignIpv6AddressesResponse.assignedIpv6Addresses(assignedIpv6Addresses);
                    break;
                }
            }
        }
        return assignIpv6AddressesResponse.build();
    }

    private static AssignIpv6AddressesResponseUnmarshaller INSTANCE;

    public static AssignIpv6AddressesResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new AssignIpv6AddressesResponseUnmarshaller();
        return INSTANCE;
    }
}
