/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ConversionTask StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ConversionTaskUnmarshaller implements Unmarshaller<ConversionTask, StaxUnmarshallerContext> {

    public ConversionTask unmarshall(StaxUnmarshallerContext context) throws Exception {
        ConversionTask.Builder conversionTask = ConversionTask.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                conversionTask.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("conversionTaskId", targetDepth)) {
                    conversionTask.conversionTaskId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("expirationTime", targetDepth)) {
                    conversionTask.expirationTime(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("importInstance", targetDepth)) {
                    conversionTask.importInstance(ImportInstanceTaskDetailsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("importVolume", targetDepth)) {
                    conversionTask.importVolume(ImportVolumeTaskDetailsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("state", targetDepth)) {
                    conversionTask.state(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("statusMessage", targetDepth)) {
                    conversionTask.statusMessage(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    conversionTask.tags(tags);
                    break;
                }
            }
        }
        return conversionTask.build();
    }

    private static ConversionTaskUnmarshaller INSTANCE;

    public static ConversionTaskUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ConversionTaskUnmarshaller();
        return INSTANCE;
    }
}
