/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * CreateNetworkInterfaceRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateNetworkInterfaceRequestMarshaller implements
        Marshaller<Request<CreateNetworkInterfaceRequest>, CreateNetworkInterfaceRequest> {

    public Request<CreateNetworkInterfaceRequest> marshall(CreateNetworkInterfaceRequest createNetworkInterfaceRequest) {

        if (createNetworkInterfaceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateNetworkInterfaceRequest> request = new DefaultRequest<CreateNetworkInterfaceRequest>(
                createNetworkInterfaceRequest, "EC2Client");
        request.addParameter("Action", "CreateNetworkInterface");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createNetworkInterfaceRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString(createNetworkInterfaceRequest.description()));
        }

        java.util.List<String> createNetworkInterfaceRequestGroupsList = createNetworkInterfaceRequest.groups();
        if (createNetworkInterfaceRequestGroupsList != null) {
            int groupsListIndex = 1;

            for (String createNetworkInterfaceRequestGroupsListValue : createNetworkInterfaceRequestGroupsList) {
                if (createNetworkInterfaceRequestGroupsListValue != null) {
                    request.addParameter("SecurityGroupId." + groupsListIndex,
                            StringUtils.fromString(createNetworkInterfaceRequestGroupsListValue));
                }
                groupsListIndex++;
            }
        }

        if (createNetworkInterfaceRequest.ipv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringUtils.fromInteger(createNetworkInterfaceRequest.ipv6AddressCount()));
        }

        java.util.List<InstanceIpv6Address> createNetworkInterfaceRequestIpv6AddressesList = createNetworkInterfaceRequest
                .ipv6Addresses();
        if (createNetworkInterfaceRequestIpv6AddressesList != null) {
            int ipv6AddressesListIndex = 1;

            for (InstanceIpv6Address createNetworkInterfaceRequestIpv6AddressesListValue : createNetworkInterfaceRequestIpv6AddressesList) {

                if (createNetworkInterfaceRequestIpv6AddressesListValue.ipv6Address() != null) {
                    request.addParameter("Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address",
                            StringUtils.fromString(createNetworkInterfaceRequestIpv6AddressesListValue.ipv6Address()));
                }
                ipv6AddressesListIndex++;
            }
        }

        if (createNetworkInterfaceRequest.privateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString(createNetworkInterfaceRequest.privateIpAddress()));
        }

        java.util.List<PrivateIpAddressSpecification> createNetworkInterfaceRequestPrivateIpAddressesList = createNetworkInterfaceRequest
                .privateIpAddresses();
        if (createNetworkInterfaceRequestPrivateIpAddressesList != null) {
            int privateIpAddressesListIndex = 1;

            for (PrivateIpAddressSpecification createNetworkInterfaceRequestPrivateIpAddressesListValue : createNetworkInterfaceRequestPrivateIpAddressesList) {

                if (createNetworkInterfaceRequestPrivateIpAddressesListValue.primary() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary",
                            StringUtils.fromBoolean(createNetworkInterfaceRequestPrivateIpAddressesListValue.primary()));
                }

                if (createNetworkInterfaceRequestPrivateIpAddressesListValue.privateIpAddress() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress",
                            StringUtils.fromString(createNetworkInterfaceRequestPrivateIpAddressesListValue.privateIpAddress()));
                }
                privateIpAddressesListIndex++;
            }
        }

        if (createNetworkInterfaceRequest.secondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount",
                    StringUtils.fromInteger(createNetworkInterfaceRequest.secondaryPrivateIpAddressCount()));
        }

        if (createNetworkInterfaceRequest.subnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString(createNetworkInterfaceRequest.subnetId()));
        }

        return request;
    }

}
