/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DeleteRouteRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteRouteRequestMarshaller implements Marshaller<Request<DeleteRouteRequest>, DeleteRouteRequest> {

    public Request<DeleteRouteRequest> marshall(DeleteRouteRequest deleteRouteRequest) {

        if (deleteRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DeleteRouteRequest> request = new DefaultRequest<DeleteRouteRequest>(deleteRouteRequest, "EC2Client");
        request.addParameter("Action", "DeleteRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (deleteRouteRequest.destinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString(deleteRouteRequest.destinationCidrBlock()));
        }

        if (deleteRouteRequest.destinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock",
                    StringUtils.fromString(deleteRouteRequest.destinationIpv6CidrBlock()));
        }

        if (deleteRouteRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString(deleteRouteRequest.routeTableId()));
        }

        return request;
    }

}
