/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DeleteTagsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteTagsRequestMarshaller implements Marshaller<Request<DeleteTagsRequest>, DeleteTagsRequest> {

    public Request<DeleteTagsRequest> marshall(DeleteTagsRequest deleteTagsRequest) {

        if (deleteTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DeleteTagsRequest> request = new DefaultRequest<DeleteTagsRequest>(deleteTagsRequest, "EC2Client");
        request.addParameter("Action", "DeleteTags");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> deleteTagsRequestResourcesList = deleteTagsRequest.resources();
        if (deleteTagsRequestResourcesList != null) {
            int resourcesListIndex = 1;

            for (String deleteTagsRequestResourcesListValue : deleteTagsRequestResourcesList) {
                if (deleteTagsRequestResourcesListValue != null) {
                    request.addParameter("ResourceId." + resourcesListIndex,
                            StringUtils.fromString(deleteTagsRequestResourcesListValue));
                }
                resourcesListIndex++;
            }
        }

        java.util.List<Tag> deleteTagsRequestTagsList = deleteTagsRequest.tags();
        if (deleteTagsRequestTagsList != null) {
            int tagsListIndex = 1;

            for (Tag deleteTagsRequestTagsListValue : deleteTagsRequestTagsList) {

                if (deleteTagsRequestTagsListValue.key() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Key",
                            StringUtils.fromString(deleteTagsRequestTagsListValue.key()));
                }

                if (deleteTagsRequestTagsListValue.value() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Value",
                            StringUtils.fromString(deleteTagsRequestTagsListValue.value()));
                }
                tagsListIndex++;
            }
        }

        return request;
    }

}
