/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeEgressOnlyInternetGatewaysResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeEgressOnlyInternetGatewaysResponseUnmarshaller implements
        Unmarshaller<DescribeEgressOnlyInternetGatewaysResponse, StaxUnmarshallerContext> {

    public DescribeEgressOnlyInternetGatewaysResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeEgressOnlyInternetGatewaysResponse.Builder describeEgressOnlyInternetGatewaysResponse = DescribeEgressOnlyInternetGatewaysResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<EgressOnlyInternetGateway> egressOnlyInternetGateways = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeEgressOnlyInternetGatewaysResponse.egressOnlyInternetGateways(egressOnlyInternetGateways);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("egressOnlyInternetGatewaySet", targetDepth)) {
                    egressOnlyInternetGateways = new ArrayList<EgressOnlyInternetGateway>();
                    continue;
                }

                if (context.testExpression("egressOnlyInternetGatewaySet/item", targetDepth)) {
                    egressOnlyInternetGateways.add(EgressOnlyInternetGatewayUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("nextToken", targetDepth)) {
                    describeEgressOnlyInternetGatewaysResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeEgressOnlyInternetGatewaysResponse.egressOnlyInternetGateways(egressOnlyInternetGateways);
                    break;
                }
            }
        }
        return describeEgressOnlyInternetGatewaysResponse.build();
    }

    private static DescribeEgressOnlyInternetGatewaysResponseUnmarshaller INSTANCE;

    public static DescribeEgressOnlyInternetGatewaysResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DescribeEgressOnlyInternetGatewaysResponseUnmarshaller();
        return INSTANCE;
    }
}
