/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DescribeHostReservationsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeHostReservationsRequestMarshaller implements
        Marshaller<Request<DescribeHostReservationsRequest>, DescribeHostReservationsRequest> {

    public Request<DescribeHostReservationsRequest> marshall(DescribeHostReservationsRequest describeHostReservationsRequest) {

        if (describeHostReservationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeHostReservationsRequest> request = new DefaultRequest<DescribeHostReservationsRequest>(
                describeHostReservationsRequest, "EC2Client");
        request.addParameter("Action", "DescribeHostReservations");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeHostReservationsRequestFilterList = describeHostReservationsRequest.filter();
        if (describeHostReservationsRequestFilterList != null) {
            int filterListIndex = 1;

            for (Filter describeHostReservationsRequestFilterListValue : describeHostReservationsRequestFilterList) {

                if (describeHostReservationsRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name",
                            StringUtils.fromString(describeHostReservationsRequestFilterListValue.name()));
                }

                java.util.List<String> filterValuesList = describeHostReservationsRequestFilterListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filterListIndex++;
            }
        }

        java.util.List<String> describeHostReservationsRequestHostReservationIdSetList = describeHostReservationsRequest
                .hostReservationIdSet();
        if (describeHostReservationsRequestHostReservationIdSetList != null) {
            int hostReservationIdSetListIndex = 1;

            for (String describeHostReservationsRequestHostReservationIdSetListValue : describeHostReservationsRequestHostReservationIdSetList) {
                if (describeHostReservationsRequestHostReservationIdSetListValue != null) {
                    request.addParameter("HostReservationIdSet." + hostReservationIdSetListIndex,
                            StringUtils.fromString(describeHostReservationsRequestHostReservationIdSetListValue));
                }
                hostReservationIdSetListIndex++;
            }
        }

        if (describeHostReservationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeHostReservationsRequest.maxResults()));
        }

        if (describeHostReservationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeHostReservationsRequest.nextToken()));
        }

        return request;
    }

}
