/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeSnapshotAttributeResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeSnapshotAttributeResponseUnmarshaller implements
        Unmarshaller<DescribeSnapshotAttributeResponse, StaxUnmarshallerContext> {

    public DescribeSnapshotAttributeResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeSnapshotAttributeResponse.Builder describeSnapshotAttributeResponse = DescribeSnapshotAttributeResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<CreateVolumePermission> createVolumePermissions = null;
        java.util.List<ProductCode> productCodes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeSnapshotAttributeResponse.createVolumePermissions(createVolumePermissions);
                describeSnapshotAttributeResponse.productCodes(productCodes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("createVolumePermission", targetDepth)) {
                    createVolumePermissions = new ArrayList<CreateVolumePermission>();
                    continue;
                }

                if (context.testExpression("createVolumePermission/item", targetDepth)) {
                    createVolumePermissions.add(CreateVolumePermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("productCodes", targetDepth)) {
                    productCodes = new ArrayList<ProductCode>();
                    continue;
                }

                if (context.testExpression("productCodes/item", targetDepth)) {
                    productCodes.add(ProductCodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("snapshotId", targetDepth)) {
                    describeSnapshotAttributeResponse.snapshotId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeSnapshotAttributeResponse.createVolumePermissions(createVolumePermissions);
                    describeSnapshotAttributeResponse.productCodes(productCodes);
                    break;
                }
            }
        }
        return describeSnapshotAttributeResponse.build();
    }

    private static DescribeSnapshotAttributeResponseUnmarshaller INSTANCE;

    public static DescribeSnapshotAttributeResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DescribeSnapshotAttributeResponseUnmarshaller();
        return INSTANCE;
    }
}
