/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DescribeVpcClassicLinkRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeVpcClassicLinkRequestMarshaller implements
        Marshaller<Request<DescribeVpcClassicLinkRequest>, DescribeVpcClassicLinkRequest> {

    public Request<DescribeVpcClassicLinkRequest> marshall(DescribeVpcClassicLinkRequest describeVpcClassicLinkRequest) {

        if (describeVpcClassicLinkRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeVpcClassicLinkRequest> request = new DefaultRequest<DescribeVpcClassicLinkRequest>(
                describeVpcClassicLinkRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpcClassicLink");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeVpcClassicLinkRequestFiltersList = describeVpcClassicLinkRequest.filters();
        if (describeVpcClassicLinkRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeVpcClassicLinkRequestFiltersListValue : describeVpcClassicLinkRequestFiltersList) {

                if (describeVpcClassicLinkRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeVpcClassicLinkRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeVpcClassicLinkRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        java.util.List<String> describeVpcClassicLinkRequestVpcIdsList = describeVpcClassicLinkRequest.vpcIds();
        if (describeVpcClassicLinkRequestVpcIdsList != null) {
            int vpcIdsListIndex = 1;

            for (String describeVpcClassicLinkRequestVpcIdsListValue : describeVpcClassicLinkRequestVpcIdsList) {
                if (describeVpcClassicLinkRequestVpcIdsListValue != null) {
                    request.addParameter("VpcId." + vpcIdsListIndex,
                            StringUtils.fromString(describeVpcClassicLinkRequestVpcIdsListValue));
                }
                vpcIdsListIndex++;
            }
        }

        return request;
    }

}
