/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DhcpOptions StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DhcpOptionsUnmarshaller implements Unmarshaller<DhcpOptions, StaxUnmarshallerContext> {

    public DhcpOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        DhcpOptions.Builder dhcpOptions = DhcpOptions.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<DhcpConfiguration> dhcpConfigurations = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                dhcpOptions.dhcpConfigurations(dhcpConfigurations);
                dhcpOptions.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("dhcpConfigurationSet", targetDepth)) {
                    dhcpConfigurations = new ArrayList<DhcpConfiguration>();
                    continue;
                }

                if (context.testExpression("dhcpConfigurationSet/item", targetDepth)) {
                    dhcpConfigurations.add(DhcpConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("dhcpOptionsId", targetDepth)) {
                    dhcpOptions.dhcpOptionsId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    dhcpOptions.dhcpConfigurations(dhcpConfigurations);
                    dhcpOptions.tags(tags);
                    break;
                }
            }
        }
        return dhcpOptions.build();
    }

    private static DhcpOptionsUnmarshaller INSTANCE;

    public static DhcpOptionsUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DhcpOptionsUnmarshaller();
        return INSTANCE;
    }
}
