/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * InstanceAttribute StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstanceAttributeUnmarshaller implements Unmarshaller<InstanceAttribute, StaxUnmarshallerContext> {

    public InstanceAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceAttribute.Builder instanceAttribute = InstanceAttribute.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<GroupIdentifier> groups = null;
        java.util.List<InstanceBlockDeviceMapping> blockDeviceMappings = null;
        java.util.List<ProductCode> productCodes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                instanceAttribute.groups(groups);
                instanceAttribute.blockDeviceMappings(blockDeviceMappings);
                instanceAttribute.productCodes(productCodes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("groupSet", targetDepth)) {
                    groups = new ArrayList<GroupIdentifier>();
                    continue;
                }

                if (context.testExpression("groupSet/item", targetDepth)) {
                    groups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("blockDeviceMapping", targetDepth)) {
                    blockDeviceMappings = new ArrayList<InstanceBlockDeviceMapping>();
                    continue;
                }

                if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                    blockDeviceMappings.add(InstanceBlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("disableApiTermination/value", targetDepth)) {
                    instanceAttribute.disableApiTermination(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("enaSupport/value", targetDepth)) {
                    instanceAttribute.enaSupport(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ebsOptimized/value", targetDepth)) {
                    instanceAttribute.ebsOptimized(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceId", targetDepth)) {
                    instanceAttribute.instanceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceInitiatedShutdownBehavior/value", targetDepth)) {
                    instanceAttribute.instanceInitiatedShutdownBehavior(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceType/value", targetDepth)) {
                    instanceAttribute.instanceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("kernel/value", targetDepth)) {
                    instanceAttribute.kernelId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("productCodes", targetDepth)) {
                    productCodes = new ArrayList<ProductCode>();
                    continue;
                }

                if (context.testExpression("productCodes/item", targetDepth)) {
                    productCodes.add(ProductCodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ramdisk/value", targetDepth)) {
                    instanceAttribute.ramdiskId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("rootDeviceName/value", targetDepth)) {
                    instanceAttribute.rootDeviceName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("sourceDestCheck/value", targetDepth)) {
                    instanceAttribute.sourceDestCheck(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("sriovNetSupport/value", targetDepth)) {
                    instanceAttribute.sriovNetSupport(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("userData/value", targetDepth)) {
                    instanceAttribute.userData(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    instanceAttribute.groups(groups);
                    instanceAttribute.blockDeviceMappings(blockDeviceMappings);
                    instanceAttribute.productCodes(productCodes);
                    break;
                }
            }
        }
        return instanceAttribute.build();
    }

    private static InstanceAttributeUnmarshaller INSTANCE;

    public static InstanceAttributeUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new InstanceAttributeUnmarshaller();
        return INSTANCE;
    }
}
