/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * ModifyImageAttributeRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ModifyImageAttributeRequestMarshaller implements
        Marshaller<Request<ModifyImageAttributeRequest>, ModifyImageAttributeRequest> {

    public Request<ModifyImageAttributeRequest> marshall(ModifyImageAttributeRequest modifyImageAttributeRequest) {

        if (modifyImageAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifyImageAttributeRequest> request = new DefaultRequest<ModifyImageAttributeRequest>(
                modifyImageAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifyImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (modifyImageAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString(modifyImageAttributeRequest.attribute()));
        }

        if (modifyImageAttributeRequest.description() != null) {
            request.addParameter("Description.Value", StringUtils.fromString(modifyImageAttributeRequest.description()));
        }

        if (modifyImageAttributeRequest.imageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(modifyImageAttributeRequest.imageId()));
        }

        LaunchPermissionModifications launchPermission = modifyImageAttributeRequest.launchPermission();
        if (launchPermission != null) {

            java.util.List<LaunchPermission> launchPermissionModificationsAddList = launchPermission.add();
            if (launchPermissionModificationsAddList != null) {
                int addListIndex = 1;

                for (LaunchPermission launchPermissionModificationsAddListValue : launchPermissionModificationsAddList) {

                    if (launchPermissionModificationsAddListValue.group() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".Group",
                                StringUtils.fromString(launchPermissionModificationsAddListValue.group()));
                    }

                    if (launchPermissionModificationsAddListValue.userId() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".UserId",
                                StringUtils.fromString(launchPermissionModificationsAddListValue.userId()));
                    }
                    addListIndex++;
                }
            }

            java.util.List<LaunchPermission> launchPermissionModificationsRemoveList = launchPermission.remove();
            if (launchPermissionModificationsRemoveList != null) {
                int removeListIndex = 1;

                for (LaunchPermission launchPermissionModificationsRemoveListValue : launchPermissionModificationsRemoveList) {

                    if (launchPermissionModificationsRemoveListValue.group() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".Group",
                                StringUtils.fromString(launchPermissionModificationsRemoveListValue.group()));
                    }

                    if (launchPermissionModificationsRemoveListValue.userId() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".UserId",
                                StringUtils.fromString(launchPermissionModificationsRemoveListValue.userId()));
                    }
                    removeListIndex++;
                }
            }
        }

        if (modifyImageAttributeRequest.operationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString(modifyImageAttributeRequest.operationType()));
        }

        java.util.List<String> modifyImageAttributeRequestProductCodesList = modifyImageAttributeRequest.productCodes();
        if (modifyImageAttributeRequestProductCodesList != null) {
            int productCodesListIndex = 1;

            for (String modifyImageAttributeRequestProductCodesListValue : modifyImageAttributeRequestProductCodesList) {
                if (modifyImageAttributeRequestProductCodesListValue != null) {
                    request.addParameter("ProductCode." + productCodesListIndex,
                            StringUtils.fromString(modifyImageAttributeRequestProductCodesListValue));
                }
                productCodesListIndex++;
            }
        }

        java.util.List<String> modifyImageAttributeRequestUserGroupsList = modifyImageAttributeRequest.userGroups();
        if (modifyImageAttributeRequestUserGroupsList != null) {
            int userGroupsListIndex = 1;

            for (String modifyImageAttributeRequestUserGroupsListValue : modifyImageAttributeRequestUserGroupsList) {
                if (modifyImageAttributeRequestUserGroupsListValue != null) {
                    request.addParameter("UserGroup." + userGroupsListIndex,
                            StringUtils.fromString(modifyImageAttributeRequestUserGroupsListValue));
                }
                userGroupsListIndex++;
            }
        }

        java.util.List<String> modifyImageAttributeRequestUserIdsList = modifyImageAttributeRequest.userIds();
        if (modifyImageAttributeRequestUserIdsList != null) {
            int userIdsListIndex = 1;

            for (String modifyImageAttributeRequestUserIdsListValue : modifyImageAttributeRequestUserIdsList) {
                if (modifyImageAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex,
                            StringUtils.fromString(modifyImageAttributeRequestUserIdsListValue));
                }
                userIdsListIndex++;
            }
        }

        if (modifyImageAttributeRequest.value() != null) {
            request.addParameter("Value", StringUtils.fromString(modifyImageAttributeRequest.value()));
        }

        return request;
    }

}
