/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AssignIpv6AddressesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AssignIpv6AddressesResponse.Builder, AssignIpv6AddressesResponse> {
    private final List<String> assignedIpv6Addresses;

    private final String networkInterfaceId;

    private AssignIpv6AddressesResponse(BuilderImpl builder) {
        this.assignedIpv6Addresses = builder.assignedIpv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    /**
     * <p>
     * The IPv6 addresses assigned to the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IPv6 addresses assigned to the network interface.
     */
    public List<String> assignedIpv6Addresses() {
        return assignedIpv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((assignedIpv6Addresses() == null) ? 0 : assignedIpv6Addresses().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaceId() == null) ? 0 : networkInterfaceId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignIpv6AddressesResponse)) {
            return false;
        }
        AssignIpv6AddressesResponse other = (AssignIpv6AddressesResponse) obj;
        if (other.assignedIpv6Addresses() == null ^ this.assignedIpv6Addresses() == null) {
            return false;
        }
        if (other.assignedIpv6Addresses() != null && !other.assignedIpv6Addresses().equals(this.assignedIpv6Addresses())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (assignedIpv6Addresses() != null) {
            sb.append("AssignedIpv6Addresses: ").append(assignedIpv6Addresses()).append(",");
        }
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AssignIpv6AddressesResponse> {
        /**
         * <p>
         * The IPv6 addresses assigned to the network interface.
         * </p>
         * 
         * @param assignedIpv6Addresses
         *        The IPv6 addresses assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedIpv6Addresses(Collection<String> assignedIpv6Addresses);

        /**
         * <p>
         * The IPv6 addresses assigned to the network interface.
         * </p>
         * 
         * @param assignedIpv6Addresses
         *        The IPv6 addresses assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedIpv6Addresses(String... assignedIpv6Addresses);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> assignedIpv6Addresses;

        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignIpv6AddressesResponse model) {
            setAssignedIpv6Addresses(model.assignedIpv6Addresses);
            setNetworkInterfaceId(model.networkInterfaceId);
        }

        public final Collection<String> getAssignedIpv6Addresses() {
            return assignedIpv6Addresses;
        }

        @Override
        public final Builder assignedIpv6Addresses(Collection<String> assignedIpv6Addresses) {
            this.assignedIpv6Addresses = Ipv6AddressListCopier.copy(assignedIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignedIpv6Addresses(String... assignedIpv6Addresses) {
            assignedIpv6Addresses(Arrays.asList(assignedIpv6Addresses));
            return this;
        }

        public final void setAssignedIpv6Addresses(Collection<String> assignedIpv6Addresses) {
            this.assignedIpv6Addresses = Ipv6AddressListCopier.copy(assignedIpv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public AssignIpv6AddressesResponse build() {
            return new AssignIpv6AddressesResponse(this);
        }
    }
}
