/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AssociateAddress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AssociateAddressRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AssociateAddressRequest.Builder, AssociateAddressRequest> {
    private final String allocationId;

    private final String instanceId;

    private final String publicIp;

    private final Boolean allowReassociation;

    private final String networkInterfaceId;

    private final String privateIpAddress;

    private AssociateAddressRequest(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.instanceId = builder.instanceId;
        this.publicIp = builder.publicIp;
        this.allowReassociation = builder.allowReassociation;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
    }

    /**
     * <p>
     * [EC2-VPC] The allocation ID. This is required for EC2-VPC.
     * </p>
     * 
     * @return [EC2-VPC] The allocation ID. This is required for EC2-VPC.
     */
    public String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The ID of the instance. This is required for EC2-Classic. For EC2-VPC, you can specify either the instance ID or
     * the network interface ID, but not both. The operation fails if you specify an instance ID unless exactly one
     * network interface is attached.
     * </p>
     * 
     * @return The ID of the instance. This is required for EC2-Classic. For EC2-VPC, you can specify either the
     *         instance ID or the network interface ID, but not both. The operation fails if you specify an instance ID
     *         unless exactly one network interface is attached.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The Elastic IP address. This is required for EC2-Classic.
     * </p>
     * 
     * @return The Elastic IP address. This is required for EC2-Classic.
     */
    public String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already
     * associated with an instance or network interface to be reassociated with the specified instance or network
     * interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic,
     * therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated
     * with another resource.
     * </p>
     * 
     * @return [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is
     *         already associated with an instance or network interface to be reassociated with the specified instance
     *         or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation
     *         is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is
     *         already associated with another resource.
     */
    public Boolean allowReassociation() {
        return allowReassociation;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must specify
     * a network interface ID.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must
     *         specify a network interface ID.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private IP
     * address is specified, the Elastic IP address is associated with the primary private IP address.
     * </p>
     * 
     * @return [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no
     *         private IP address is specified, the Elastic IP address is associated with the primary private IP
     *         address.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((allocationId() == null) ? 0 : allocationId().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((publicIp() == null) ? 0 : publicIp().hashCode());
        hashCode = 31 * hashCode + ((allowReassociation() == null) ? 0 : allowReassociation().hashCode());
        hashCode = 31 * hashCode + ((networkInterfaceId() == null) ? 0 : networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddress() == null) ? 0 : privateIpAddress().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAddressRequest)) {
            return false;
        }
        AssociateAddressRequest other = (AssociateAddressRequest) obj;
        if (other.allocationId() == null ^ this.allocationId() == null) {
            return false;
        }
        if (other.allocationId() != null && !other.allocationId().equals(this.allocationId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        if (other.allowReassociation() == null ^ this.allowReassociation() == null) {
            return false;
        }
        if (other.allowReassociation() != null && !other.allowReassociation().equals(this.allowReassociation())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (allocationId() != null) {
            sb.append("AllocationId: ").append(allocationId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (publicIp() != null) {
            sb.append("PublicIp: ").append(publicIp()).append(",");
        }
        if (allowReassociation() != null) {
            sb.append("AllowReassociation: ").append(allowReassociation()).append(",");
        }
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AssociateAddressRequest> {
        /**
         * <p>
         * [EC2-VPC] The allocation ID. This is required for EC2-VPC.
         * </p>
         * 
         * @param allocationId
         *        [EC2-VPC] The allocation ID. This is required for EC2-VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The ID of the instance. This is required for EC2-Classic. For EC2-VPC, you can specify either the instance ID
         * or the network interface ID, but not both. The operation fails if you specify an instance ID unless exactly
         * one network interface is attached.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance. This is required for EC2-Classic. For EC2-VPC, you can specify either the
         *        instance ID or the network interface ID, but not both. The operation fails if you specify an instance
         *        ID unless exactly one network interface is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The Elastic IP address. This is required for EC2-Classic.
         * </p>
         * 
         * @param publicIp
         *        The Elastic IP address. This is required for EC2-Classic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already
         * associated with an instance or network interface to be reassociated with the specified instance or network
         * interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic,
         * therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated
         * with another resource.
         * </p>
         * 
         * @param allowReassociation
         *        [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is
         *        already associated with an instance or network interface to be reassociated with the specified
         *        instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account,
         *        reassociation is automatic, therefore you can specify false to ensure the operation fails if the
         *        Elastic IP address is already associated with another resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowReassociation(Boolean allowReassociation);

        /**
         * <p>
         * [EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must
         * specify a network interface ID.
         * </p>
         * 
         * @param networkInterfaceId
         *        [EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you
         *        must specify a network interface ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private
         * IP address is specified, the Elastic IP address is associated with the primary private IP address.
         * </p>
         * 
         * @param privateIpAddress
         *        [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no
         *        private IP address is specified, the Elastic IP address is associated with the primary private IP
         *        address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);
    }

    private static final class BuilderImpl implements Builder {
        private String allocationId;

        private String instanceId;

        private String publicIp;

        private Boolean allowReassociation;

        private String networkInterfaceId;

        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAddressRequest model) {
            setAllocationId(model.allocationId);
            setInstanceId(model.instanceId);
            setPublicIp(model.publicIp);
            setAllowReassociation(model.allowReassociation);
            setNetworkInterfaceId(model.networkInterfaceId);
            setPrivateIpAddress(model.privateIpAddress);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final Boolean getAllowReassociation() {
            return allowReassociation;
        }

        @Override
        public final Builder allowReassociation(Boolean allowReassociation) {
            this.allowReassociation = allowReassociation;
            return this;
        }

        public final void setAllowReassociation(Boolean allowReassociation) {
            this.allowReassociation = allowReassociation;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public AssociateAddressRequest build() {
            return new AssociateAddressRequest(this);
        }
    }
}
