/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BlockDeviceMapping implements ToCopyableBuilder<BlockDeviceMapping.Builder, BlockDeviceMapping> {
    private final String deviceName;

    private final String virtualName;

    private final EbsBlockDevice ebs;

    private final String noDevice;

    private BlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.virtualName = builder.virtualName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
    }

    /**
     * <p>
     * The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * 
     * @return The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An
     * instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and
     * <code>ephemeral1</code>.The number of available instance store volumes depends on the instance type. After you
     * connect to the instance, you must mount the volume.
     * </p>
     * <p>
     * Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the
     * instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device
     * mapping for the AMI.
     * </p>
     * 
     * @return The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0.
     *         An instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code>
     *         and <code>ephemeral1</code>.The number of available instance store volumes depends on the instance type.
     *         After you connect to the instance, you must mount the volume.</p>
     *         <p>
     *         Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for
     *         the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block
     *         device mapping for the AMI.
     */
    public String virtualName() {
        return virtualName;
    }

    /**
     * <p>
     * Parameters used to automatically set up EBS volumes when the instance is launched.
     * </p>
     * 
     * @return Parameters used to automatically set up EBS volumes when the instance is launched.
     */
    public EbsBlockDevice ebs() {
        return ebs;
    }

    /**
     * <p>
     * Suppresses the specified device included in the block device mapping of the AMI.
     * </p>
     * 
     * @return Suppresses the specified device included in the block device mapping of the AMI.
     */
    public String noDevice() {
        return noDevice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deviceName() == null) ? 0 : deviceName().hashCode());
        hashCode = 31 * hashCode + ((virtualName() == null) ? 0 : virtualName().hashCode());
        hashCode = 31 * hashCode + ((ebs() == null) ? 0 : ebs().hashCode());
        hashCode = 31 * hashCode + ((noDevice() == null) ? 0 : noDevice().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMapping)) {
            return false;
        }
        BlockDeviceMapping other = (BlockDeviceMapping) obj;
        if (other.deviceName() == null ^ this.deviceName() == null) {
            return false;
        }
        if (other.deviceName() != null && !other.deviceName().equals(this.deviceName())) {
            return false;
        }
        if (other.virtualName() == null ^ this.virtualName() == null) {
            return false;
        }
        if (other.virtualName() != null && !other.virtualName().equals(this.virtualName())) {
            return false;
        }
        if (other.ebs() == null ^ this.ebs() == null) {
            return false;
        }
        if (other.ebs() != null && !other.ebs().equals(this.ebs())) {
            return false;
        }
        if (other.noDevice() == null ^ this.noDevice() == null) {
            return false;
        }
        if (other.noDevice() != null && !other.noDevice().equals(this.noDevice())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deviceName() != null) {
            sb.append("DeviceName: ").append(deviceName()).append(",");
        }
        if (virtualName() != null) {
            sb.append("VirtualName: ").append(virtualName()).append(",");
        }
        if (ebs() != null) {
            sb.append("Ebs: ").append(ebs()).append(",");
        }
        if (noDevice() != null) {
            sb.append("NoDevice: ").append(noDevice()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BlockDeviceMapping> {
        /**
         * <p>
         * The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * 
         * @param deviceName
         *        The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An
         * instance type with 2 available instance store volumes can specify mappings for <code>ephemeral0</code> and
         * <code>ephemeral1</code>.The number of available instance store volumes depends on the instance type. After
         * you connect to the instance, you must mount the volume.
         * </p>
         * <p>
         * Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the
         * instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device
         * mapping for the AMI.
         * </p>
         * 
         * @param virtualName
         *        The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from
         *        0. An instance type with 2 available instance store volumes can specify mappings for
         *        <code>ephemeral0</code> and <code>ephemeral1</code>.The number of available instance store volumes
         *        depends on the instance type. After you connect to the instance, you must mount the volume.</p>
         *        <p>
         *        Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for
         *        the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the
         *        block device mapping for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);

        /**
         * <p>
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         * </p>
         * 
         * @param ebs
         *        Parameters used to automatically set up EBS volumes when the instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(EbsBlockDevice ebs);

        /**
         * <p>
         * Suppresses the specified device included in the block device mapping of the AMI.
         * </p>
         * 
         * @param noDevice
         *        Suppresses the specified device included in the block device mapping of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(String noDevice);
    }

    private static final class BuilderImpl implements Builder {
        private String deviceName;

        private String virtualName;

        private EbsBlockDevice ebs;

        private String noDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMapping model) {
            setDeviceName(model.deviceName);
            setVirtualName(model.virtualName);
            setEbs(model.ebs);
            setNoDevice(model.noDevice);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getVirtualName() {
            return virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public final EbsBlockDevice getEbs() {
            return ebs;
        }

        @Override
        public final Builder ebs(EbsBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsBlockDevice ebs) {
            this.ebs = ebs;
        }

        public final String getNoDevice() {
            return noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        @Override
        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this);
        }
    }
}
