/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for BundleInstance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BundleInstanceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<BundleInstanceRequest.Builder, BundleInstanceRequest> {
    private final String instanceId;

    private final Storage storage;

    private BundleInstanceRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.storage = builder.storage;
    }

    /**
     * <p>
     * The ID of the instance to bundle.
     * </p>
     * <p>
     * Type: String
     * </p>
     * <p>
     * Default: None
     * </p>
     * <p>
     * Required: Yes
     * </p>
     * 
     * @return The ID of the instance to bundle.</p>
     *         <p>
     *         Type: String
     *         </p>
     *         <p>
     *         Default: None
     *         </p>
     *         <p>
     *         Required: Yes
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon
     * EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
     * </p>
     * 
     * @return The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that
     *         Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2
     *         returns an error.
     */
    public Storage storage() {
        return storage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((storage() == null) ? 0 : storage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleInstanceRequest)) {
            return false;
        }
        BundleInstanceRequest other = (BundleInstanceRequest) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.storage() == null ^ this.storage() == null) {
            return false;
        }
        if (other.storage() != null && !other.storage().equals(this.storage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (storage() != null) {
            sb.append("Storage: ").append(storage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BundleInstanceRequest> {
        /**
         * <p>
         * The ID of the instance to bundle.
         * </p>
         * <p>
         * Type: String
         * </p>
         * <p>
         * Default: None
         * </p>
         * <p>
         * Required: Yes
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance to bundle.</p>
         *        <p>
         *        Type: String
         *        </p>
         *        <p>
         *        Default: None
         *        </p>
         *        <p>
         *        Required: Yes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that
         * Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns
         * an error.
         * </p>
         * 
         * @param storage
         *        The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket
         *        that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon
         *        EC2 returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(Storage storage);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private Storage storage;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleInstanceRequest model) {
            setInstanceId(model.instanceId);
            setStorage(model.storage);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Storage getStorage() {
            return storage;
        }

        @Override
        public final Builder storage(Storage storage) {
            this.storage = storage;
            return this;
        }

        public final void setStorage(Storage storage) {
            this.storage = storage;
        }

        @Override
        public BundleInstanceRequest build() {
            return new BundleInstanceRequest(this);
        }
    }
}
