/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of BundleInstance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BundleInstanceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<BundleInstanceResponse.Builder, BundleInstanceResponse> {
    private final BundleTask bundleTask;

    private BundleInstanceResponse(BuilderImpl builder) {
        this.bundleTask = builder.bundleTask;
    }

    /**
     * <p>
     * Information about the bundle task.
     * </p>
     * 
     * @return Information about the bundle task.
     */
    public BundleTask bundleTask() {
        return bundleTask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bundleTask() == null) ? 0 : bundleTask().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleInstanceResponse)) {
            return false;
        }
        BundleInstanceResponse other = (BundleInstanceResponse) obj;
        if (other.bundleTask() == null ^ this.bundleTask() == null) {
            return false;
        }
        if (other.bundleTask() != null && !other.bundleTask().equals(this.bundleTask())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bundleTask() != null) {
            sb.append("BundleTask: ").append(bundleTask()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BundleInstanceResponse> {
        /**
         * <p>
         * Information about the bundle task.
         * </p>
         * 
         * @param bundleTask
         *        Information about the bundle task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleTask(BundleTask bundleTask);
    }

    private static final class BuilderImpl implements Builder {
        private BundleTask bundleTask;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleInstanceResponse model) {
            setBundleTask(model.bundleTask);
        }

        public final BundleTask getBundleTask() {
            return bundleTask;
        }

        @Override
        public final Builder bundleTask(BundleTask bundleTask) {
            this.bundleTask = bundleTask;
            return this;
        }

        public final void setBundleTask(BundleTask bundleTask) {
            this.bundleTask = bundleTask;
        }

        @Override
        public BundleInstanceResponse build() {
            return new BundleInstanceResponse(this);
        }
    }
}
