/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelReservedInstancesListing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelReservedInstancesListingRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CancelReservedInstancesListingRequest.Builder, CancelReservedInstancesListingRequest> {
    private final String reservedInstancesListingId;

    private CancelReservedInstancesListingRequest(BuilderImpl builder) {
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
    }

    /**
     * <p>
     * The ID of the Reserved Instance listing.
     * </p>
     * 
     * @return The ID of the Reserved Instance listing.
     */
    public String reservedInstancesListingId() {
        return reservedInstancesListingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((reservedInstancesListingId() == null) ? 0 : reservedInstancesListingId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelReservedInstancesListingRequest)) {
            return false;
        }
        CancelReservedInstancesListingRequest other = (CancelReservedInstancesListingRequest) obj;
        if (other.reservedInstancesListingId() == null ^ this.reservedInstancesListingId() == null) {
            return false;
        }
        if (other.reservedInstancesListingId() != null
                && !other.reservedInstancesListingId().equals(this.reservedInstancesListingId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (reservedInstancesListingId() != null) {
            sb.append("ReservedInstancesListingId: ").append(reservedInstancesListingId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CancelReservedInstancesListingRequest> {
        /**
         * <p>
         * The ID of the Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListingId
         *        The ID of the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListingId(String reservedInstancesListingId);
    }

    private static final class BuilderImpl implements Builder {
        private String reservedInstancesListingId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelReservedInstancesListingRequest model) {
            setReservedInstancesListingId(model.reservedInstancesListingId);
        }

        public final String getReservedInstancesListingId() {
            return reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        @Override
        public CancelReservedInstancesListingRequest build() {
            return new CancelReservedInstancesListingRequest(this);
        }
    }
}
