/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelSpotFleetRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelSpotFleetRequestsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CancelSpotFleetRequestsRequest.Builder, CancelSpotFleetRequestsRequest> {
    private final List<String> spotFleetRequestIds;

    private final Boolean terminateInstances;

    private CancelSpotFleetRequestsRequest(BuilderImpl builder) {
        this.spotFleetRequestIds = builder.spotFleetRequestIds;
        this.terminateInstances = builder.terminateInstances;
    }

    /**
     * <p>
     * The IDs of the Spot fleet requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Spot fleet requests.
     */
    public List<String> spotFleetRequestIds() {
        return spotFleetRequestIds;
    }

    /**
     * <p>
     * Indicates whether to terminate instances for a Spot fleet request if it is canceled successfully.
     * </p>
     * 
     * @return Indicates whether to terminate instances for a Spot fleet request if it is canceled successfully.
     */
    public Boolean terminateInstances() {
        return terminateInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((spotFleetRequestIds() == null) ? 0 : spotFleetRequestIds().hashCode());
        hashCode = 31 * hashCode + ((terminateInstances() == null) ? 0 : terminateInstances().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsRequest)) {
            return false;
        }
        CancelSpotFleetRequestsRequest other = (CancelSpotFleetRequestsRequest) obj;
        if (other.spotFleetRequestIds() == null ^ this.spotFleetRequestIds() == null) {
            return false;
        }
        if (other.spotFleetRequestIds() != null && !other.spotFleetRequestIds().equals(this.spotFleetRequestIds())) {
            return false;
        }
        if (other.terminateInstances() == null ^ this.terminateInstances() == null) {
            return false;
        }
        if (other.terminateInstances() != null && !other.terminateInstances().equals(this.terminateInstances())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (spotFleetRequestIds() != null) {
            sb.append("SpotFleetRequestIds: ").append(spotFleetRequestIds()).append(",");
        }
        if (terminateInstances() != null) {
            sb.append("TerminateInstances: ").append(terminateInstances()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CancelSpotFleetRequestsRequest> {
        /**
         * <p>
         * The IDs of the Spot fleet requests.
         * </p>
         * 
         * @param spotFleetRequestIds
         *        The IDs of the Spot fleet requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestIds(Collection<String> spotFleetRequestIds);

        /**
         * <p>
         * The IDs of the Spot fleet requests.
         * </p>
         * 
         * @param spotFleetRequestIds
         *        The IDs of the Spot fleet requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestIds(String... spotFleetRequestIds);

        /**
         * <p>
         * Indicates whether to terminate instances for a Spot fleet request if it is canceled successfully.
         * </p>
         * 
         * @param terminateInstances
         *        Indicates whether to terminate instances for a Spot fleet request if it is canceled successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateInstances(Boolean terminateInstances);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> spotFleetRequestIds;

        private Boolean terminateInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsRequest model) {
            setSpotFleetRequestIds(model.spotFleetRequestIds);
            setTerminateInstances(model.terminateInstances);
        }

        public final Collection<String> getSpotFleetRequestIds() {
            return spotFleetRequestIds;
        }

        @Override
        public final Builder spotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = ValueStringListCopier.copy(spotFleetRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestIds(String... spotFleetRequestIds) {
            spotFleetRequestIds(Arrays.asList(spotFleetRequestIds));
            return this;
        }

        public final void setSpotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = ValueStringListCopier.copy(spotFleetRequestIds);
        }

        public final Boolean getTerminateInstances() {
            return terminateInstances;
        }

        @Override
        public final Builder terminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
            return this;
        }

        public final void setTerminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
        }

        @Override
        public CancelSpotFleetRequestsRequest build() {
            return new CancelSpotFleetRequestsRequest(this);
        }
    }
}
