/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CancelSpotFleetRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelSpotFleetRequestsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CancelSpotFleetRequestsResponse.Builder, CancelSpotFleetRequestsResponse> {
    private final List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests;

    private final List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests;

    private CancelSpotFleetRequestsResponse(BuilderImpl builder) {
        this.successfulFleetRequests = builder.successfulFleetRequests;
        this.unsuccessfulFleetRequests = builder.unsuccessfulFleetRequests;
    }

    /**
     * <p>
     * Information about the Spot fleet requests that are successfully canceled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Spot fleet requests that are successfully canceled.
     */
    public List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests() {
        return successfulFleetRequests;
    }

    /**
     * <p>
     * Information about the Spot fleet requests that are not successfully canceled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Spot fleet requests that are not successfully canceled.
     */
    public List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests() {
        return unsuccessfulFleetRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((successfulFleetRequests() == null) ? 0 : successfulFleetRequests().hashCode());
        hashCode = 31 * hashCode + ((unsuccessfulFleetRequests() == null) ? 0 : unsuccessfulFleetRequests().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsResponse)) {
            return false;
        }
        CancelSpotFleetRequestsResponse other = (CancelSpotFleetRequestsResponse) obj;
        if (other.successfulFleetRequests() == null ^ this.successfulFleetRequests() == null) {
            return false;
        }
        if (other.successfulFleetRequests() != null && !other.successfulFleetRequests().equals(this.successfulFleetRequests())) {
            return false;
        }
        if (other.unsuccessfulFleetRequests() == null ^ this.unsuccessfulFleetRequests() == null) {
            return false;
        }
        if (other.unsuccessfulFleetRequests() != null
                && !other.unsuccessfulFleetRequests().equals(this.unsuccessfulFleetRequests())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (successfulFleetRequests() != null) {
            sb.append("SuccessfulFleetRequests: ").append(successfulFleetRequests()).append(",");
        }
        if (unsuccessfulFleetRequests() != null) {
            sb.append("UnsuccessfulFleetRequests: ").append(unsuccessfulFleetRequests()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CancelSpotFleetRequestsResponse> {
        /**
         * <p>
         * Information about the Spot fleet requests that are successfully canceled.
         * </p>
         * 
         * @param successfulFleetRequests
         *        Information about the Spot fleet requests that are successfully canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests);

        /**
         * <p>
         * Information about the Spot fleet requests that are successfully canceled.
         * </p>
         * 
         * @param successfulFleetRequests
         *        Information about the Spot fleet requests that are successfully canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulFleetRequests(CancelSpotFleetRequestsSuccessItem... successfulFleetRequests);

        /**
         * <p>
         * Information about the Spot fleet requests that are not successfully canceled.
         * </p>
         * 
         * @param unsuccessfulFleetRequests
         *        Information about the Spot fleet requests that are not successfully canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests);

        /**
         * <p>
         * Information about the Spot fleet requests that are not successfully canceled.
         * </p>
         * 
         * @param unsuccessfulFleetRequests
         *        Information about the Spot fleet requests that are not successfully canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFleetRequests(CancelSpotFleetRequestsErrorItem... unsuccessfulFleetRequests);
    }

    private static final class BuilderImpl implements Builder {
        private List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests;

        private List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsResponse model) {
            setSuccessfulFleetRequests(model.successfulFleetRequests);
            setUnsuccessfulFleetRequests(model.unsuccessfulFleetRequests);
        }

        public final Collection<CancelSpotFleetRequestsSuccessItem> getSuccessfulFleetRequests() {
            return successfulFleetRequests;
        }

        @Override
        public final Builder successfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests) {
            this.successfulFleetRequests = CancelSpotFleetRequestsSuccessSetCopier.copy(successfulFleetRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetRequests(CancelSpotFleetRequestsSuccessItem... successfulFleetRequests) {
            successfulFleetRequests(Arrays.asList(successfulFleetRequests));
            return this;
        }

        public final void setSuccessfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests) {
            this.successfulFleetRequests = CancelSpotFleetRequestsSuccessSetCopier.copy(successfulFleetRequests);
        }

        public final Collection<CancelSpotFleetRequestsErrorItem> getUnsuccessfulFleetRequests() {
            return unsuccessfulFleetRequests;
        }

        @Override
        public final Builder unsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests = CancelSpotFleetRequestsErrorSetCopier.copy(unsuccessfulFleetRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFleetRequests(CancelSpotFleetRequestsErrorItem... unsuccessfulFleetRequests) {
            unsuccessfulFleetRequests(Arrays.asList(unsuccessfulFleetRequests));
            return this;
        }

        public final void setUnsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests = CancelSpotFleetRequestsErrorSetCopier.copy(unsuccessfulFleetRequests);
        }

        @Override
        public CancelSpotFleetRequestsResponse build() {
            return new CancelSpotFleetRequestsResponse(this);
        }
    }
}
