/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateCustomerGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCustomerGatewayResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateCustomerGatewayResponse.Builder, CreateCustomerGatewayResponse> {
    private final CustomerGateway customerGateway;

    private CreateCustomerGatewayResponse(BuilderImpl builder) {
        this.customerGateway = builder.customerGateway;
    }

    /**
     * <p>
     * Information about the customer gateway.
     * </p>
     * 
     * @return Information about the customer gateway.
     */
    public CustomerGateway customerGateway() {
        return customerGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((customerGateway() == null) ? 0 : customerGateway().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomerGatewayResponse)) {
            return false;
        }
        CreateCustomerGatewayResponse other = (CreateCustomerGatewayResponse) obj;
        if (other.customerGateway() == null ^ this.customerGateway() == null) {
            return false;
        }
        if (other.customerGateway() != null && !other.customerGateway().equals(this.customerGateway())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (customerGateway() != null) {
            sb.append("CustomerGateway: ").append(customerGateway()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateCustomerGatewayResponse> {
        /**
         * <p>
         * Information about the customer gateway.
         * </p>
         * 
         * @param customerGateway
         *        Information about the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGateway(CustomerGateway customerGateway);
    }

    private static final class BuilderImpl implements Builder {
        private CustomerGateway customerGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomerGatewayResponse model) {
            setCustomerGateway(model.customerGateway);
        }

        public final CustomerGateway getCustomerGateway() {
            return customerGateway;
        }

        @Override
        public final Builder customerGateway(CustomerGateway customerGateway) {
            this.customerGateway = customerGateway;
            return this;
        }

        public final void setCustomerGateway(CustomerGateway customerGateway) {
            this.customerGateway = customerGateway;
        }

        @Override
        public CreateCustomerGatewayResponse build() {
            return new CreateCustomerGatewayResponse(this);
        }
    }
}
