/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateNetworkAclEntry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateNetworkAclEntryRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateNetworkAclEntryRequest.Builder, CreateNetworkAclEntryRequest> {
    private final String cidrBlock;

    private final Boolean egress;

    private final IcmpTypeCode icmpTypeCode;

    private final String ipv6CidrBlock;

    private final String networkAclId;

    private final PortRange portRange;

    private final String protocol;

    private final String ruleAction;

    private final Integer ruleNumber;

    private CreateNetworkAclEntryRequest(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.egress = builder.egress;
        this.icmpTypeCode = builder.icmpTypeCode;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.networkAclId = builder.networkAclId;
        this.portRange = builder.portRange;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.ruleNumber = builder.ruleNumber;
    }

    /**
     * <p>
     * The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).
     * </p>
     * 
     * @return The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).
     * </p>
     * 
     * @return Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).
     */
    public Boolean egress() {
        return egress;
    }

    /**
     * <p>
     * ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying the ICMP protocol, or protocol 58
     * (ICMPv6) with an IPv6 CIDR block.
     * </p>
     * 
     * @return ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying the ICMP protocol, or protocol 58
     *         (ICMPv6) with an IPv6 CIDR block.
     */
    public IcmpTypeCode icmpTypeCode() {
        return icmpTypeCode;
    }

    /**
     * <p>
     * The IPv6 network range to allow or deny, in CIDR notation (for example <code>2001:db8:1234:1a00::/64</code>).
     * </p>
     * 
     * @return The IPv6 network range to allow or deny, in CIDR notation (for example
     *         <code>2001:db8:1234:1a00::/64</code>).
     */
    public String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * The ID of the network ACL.
     * </p>
     * 
     * @return The ID of the network ACL.
     */
    public String networkAclId() {
        return networkAclId;
    }

    /**
     * <p>
     * TCP or UDP protocols: The range of ports the rule applies to.
     * </p>
     * 
     * @return TCP or UDP protocols: The range of ports the rule applies to.
     */
    public PortRange portRange() {
        return portRange;
    }

    /**
     * <p>
     * The protocol. A value of <code>-1</code> or <code>all</code> means all protocols. If you specify <code>all</code>, <code>-1</code>, or a protocol number other than <code>tcp</code>, <code>udp</code>, or <code>icmp</code>,
     * traffic on all ports is allowed, regardless of any ports or ICMP types or codes you specify. If you specify
     * protocol <code>58</code> (ICMPv6) and specify an IPv4 CIDR block, traffic for all ICMP types and codes allowed,
     * regardless of any that you specify. If you specify protocol <code>58</code> (ICMPv6) and specify an IPv6 CIDR
     * block, you must specify an ICMP type and code.
     * </p>
     * 
     * @return The protocol. A value of <code>-1</code> or <code>all</code> means all protocols. If you specify
     *         <code>all</code>, <code>-1</code>, or a protocol number other than <code>tcp</code>, <code>udp</code>, or
     *         <code>icmp</code>, traffic on all ports is allowed, regardless of any ports or ICMP types or codes you
     *         specify. If you specify protocol <code>58</code> (ICMPv6) and specify an IPv4 CIDR block, traffic for all
     *         ICMP types and codes allowed, regardless of any that you specify. If you specify protocol <code>58</code>
     *         (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.
     */
    public String protocol() {
        return protocol;
    }

    /**
     * <p>
     * Indicates whether to allow or deny the traffic that matches the rule.
     * </p>
     * 
     * @return Indicates whether to allow or deny the traffic that matches the rule.
     * @see RuleAction
     */
    public String ruleAction() {
        return ruleAction;
    }

    /**
     * <p>
     * The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule number.
     * </p>
     * <p>
     * Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.
     * </p>
     * 
     * @return The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule
     *         number.</p>
     *         <p>
     *         Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.
     */
    public Integer ruleNumber() {
        return ruleNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cidrBlock() == null) ? 0 : cidrBlock().hashCode());
        hashCode = 31 * hashCode + ((egress() == null) ? 0 : egress().hashCode());
        hashCode = 31 * hashCode + ((icmpTypeCode() == null) ? 0 : icmpTypeCode().hashCode());
        hashCode = 31 * hashCode + ((ipv6CidrBlock() == null) ? 0 : ipv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + ((networkAclId() == null) ? 0 : networkAclId().hashCode());
        hashCode = 31 * hashCode + ((portRange() == null) ? 0 : portRange().hashCode());
        hashCode = 31 * hashCode + ((protocol() == null) ? 0 : protocol().hashCode());
        hashCode = 31 * hashCode + ((ruleAction() == null) ? 0 : ruleAction().hashCode());
        hashCode = 31 * hashCode + ((ruleNumber() == null) ? 0 : ruleNumber().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkAclEntryRequest)) {
            return false;
        }
        CreateNetworkAclEntryRequest other = (CreateNetworkAclEntryRequest) obj;
        if (other.cidrBlock() == null ^ this.cidrBlock() == null) {
            return false;
        }
        if (other.cidrBlock() != null && !other.cidrBlock().equals(this.cidrBlock())) {
            return false;
        }
        if (other.egress() == null ^ this.egress() == null) {
            return false;
        }
        if (other.egress() != null && !other.egress().equals(this.egress())) {
            return false;
        }
        if (other.icmpTypeCode() == null ^ this.icmpTypeCode() == null) {
            return false;
        }
        if (other.icmpTypeCode() != null && !other.icmpTypeCode().equals(this.icmpTypeCode())) {
            return false;
        }
        if (other.ipv6CidrBlock() == null ^ this.ipv6CidrBlock() == null) {
            return false;
        }
        if (other.ipv6CidrBlock() != null && !other.ipv6CidrBlock().equals(this.ipv6CidrBlock())) {
            return false;
        }
        if (other.networkAclId() == null ^ this.networkAclId() == null) {
            return false;
        }
        if (other.networkAclId() != null && !other.networkAclId().equals(this.networkAclId())) {
            return false;
        }
        if (other.portRange() == null ^ this.portRange() == null) {
            return false;
        }
        if (other.portRange() != null && !other.portRange().equals(this.portRange())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.ruleAction() == null ^ this.ruleAction() == null) {
            return false;
        }
        if (other.ruleAction() != null && !other.ruleAction().equals(this.ruleAction())) {
            return false;
        }
        if (other.ruleNumber() == null ^ this.ruleNumber() == null) {
            return false;
        }
        if (other.ruleNumber() != null && !other.ruleNumber().equals(this.ruleNumber())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (cidrBlock() != null) {
            sb.append("CidrBlock: ").append(cidrBlock()).append(",");
        }
        if (egress() != null) {
            sb.append("Egress: ").append(egress()).append(",");
        }
        if (icmpTypeCode() != null) {
            sb.append("IcmpTypeCode: ").append(icmpTypeCode()).append(",");
        }
        if (ipv6CidrBlock() != null) {
            sb.append("Ipv6CidrBlock: ").append(ipv6CidrBlock()).append(",");
        }
        if (networkAclId() != null) {
            sb.append("NetworkAclId: ").append(networkAclId()).append(",");
        }
        if (portRange() != null) {
            sb.append("PortRange: ").append(portRange()).append(",");
        }
        if (protocol() != null) {
            sb.append("Protocol: ").append(protocol()).append(",");
        }
        if (ruleAction() != null) {
            sb.append("RuleAction: ").append(ruleAction()).append(",");
        }
        if (ruleNumber() != null) {
            sb.append("RuleNumber: ").append(ruleNumber()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateNetworkAclEntryRequest> {
        /**
         * <p>
         * The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 network range to allow or deny, in CIDR notation (for example <code>172.16.0.0/24</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).
         * </p>
         * 
         * @param egress
         *        Indicates whether this is an egress rule (rule is applied to traffic leaving the subnet).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egress(Boolean egress);

        /**
         * <p>
         * ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying the ICMP protocol, or protocol 58
         * (ICMPv6) with an IPv6 CIDR block.
         * </p>
         * 
         * @param icmpTypeCode
         *        ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying the ICMP protocol, or protocol
         *        58 (ICMPv6) with an IPv6 CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icmpTypeCode(IcmpTypeCode icmpTypeCode);

        /**
         * <p>
         * The IPv6 network range to allow or deny, in CIDR notation (for example <code>2001:db8:1234:1a00::/64</code>).
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 network range to allow or deny, in CIDR notation (for example
         *        <code>2001:db8:1234:1a00::/64</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * The ID of the network ACL.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);

        /**
         * <p>
         * TCP or UDP protocols: The range of ports the rule applies to.
         * </p>
         * 
         * @param portRange
         *        TCP or UDP protocols: The range of ports the rule applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRange(PortRange portRange);

        /**
         * <p>
         * The protocol. A value of <code>-1</code> or <code>all</code> means all protocols. If you specify
         * <code>all</code>, <code>-1</code>, or a protocol number other than <code>tcp</code>, <code>udp</code>, or
         * <code>icmp</code>, traffic on all ports is allowed, regardless of any ports or ICMP types or codes you
         * specify. If you specify protocol <code>58</code> (ICMPv6) and specify an IPv4 CIDR block, traffic for all
         * ICMP types and codes allowed, regardless of any that you specify. If you specify protocol <code>58</code>
         * (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.
         * </p>
         * 
         * @param protocol
         *        The protocol. A value of <code>-1</code> or <code>all</code> means all protocols. If you specify
         *        <code>all</code>, <code>-1</code>, or a protocol number other than <code>tcp</code>, <code>udp</code>,
         *        or <code>icmp</code>, traffic on all ports is allowed, regardless of any ports or ICMP types or codes
         *        you specify. If you specify protocol <code>58</code> (ICMPv6) and specify an IPv4 CIDR block, traffic
         *        for all ICMP types and codes allowed, regardless of any that you specify. If you specify protocol
         *        <code>58</code> (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Indicates whether to allow or deny the traffic that matches the rule.
         * </p>
         * 
         * @param ruleAction
         *        Indicates whether to allow or deny the traffic that matches the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder ruleAction(String ruleAction);

        /**
         * <p>
         * Indicates whether to allow or deny the traffic that matches the rule.
         * </p>
         * 
         * @param ruleAction
         *        Indicates whether to allow or deny the traffic that matches the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder ruleAction(RuleAction ruleAction);

        /**
         * <p>
         * The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule
         * number.
         * </p>
         * <p>
         * Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.
         * </p>
         * 
         * @param ruleNumber
         *        The rule number for the entry (for example, 100). ACL entries are processed in ascending order by rule
         *        number.</p>
         *        <p>
         *        Constraints: Positive integer from 1 to 32766. The range 32767 to 65535 is reserved for internal use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);
    }

    private static final class BuilderImpl implements Builder {
        private String cidrBlock;

        private Boolean egress;

        private IcmpTypeCode icmpTypeCode;

        private String ipv6CidrBlock;

        private String networkAclId;

        private PortRange portRange;

        private String protocol;

        private String ruleAction;

        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkAclEntryRequest model) {
            setCidrBlock(model.cidrBlock);
            setEgress(model.egress);
            setIcmpTypeCode(model.icmpTypeCode);
            setIpv6CidrBlock(model.ipv6CidrBlock);
            setNetworkAclId(model.networkAclId);
            setPortRange(model.portRange);
            setProtocol(model.protocol);
            setRuleAction(model.ruleAction);
            setRuleNumber(model.ruleNumber);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getEgress() {
            return egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        public final IcmpTypeCode getIcmpTypeCode() {
            return icmpTypeCode;
        }

        @Override
        public final Builder icmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final void setIcmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final PortRange getPortRange() {
            return portRange;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final void setPortRange(PortRange portRange) {
            this.portRange = portRange;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRuleAction() {
            return ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction(ruleAction.toString());
            return this;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public CreateNetworkAclEntryRequest build() {
            return new CreateNetworkAclEntryRequest(this);
        }
    }
}
