/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A simple result wrapper around the Snapshot object that was sent over the wire.
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateSnapshotResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateSnapshotResponse.Builder, CreateSnapshotResponse> {
    private final Snapshot snapshot;

    private CreateSnapshotResponse(BuilderImpl builder) {
        this.snapshot = builder.snapshot;
    }

    /**
     * <p>
     * Describes a snapshot.
     * </p>
     * 
     * @return Describes a snapshot.
     */
    public Snapshot snapshot() {
        return snapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((snapshot() == null) ? 0 : snapshot().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotResponse)) {
            return false;
        }
        CreateSnapshotResponse other = (CreateSnapshotResponse) obj;
        if (other.snapshot() == null ^ this.snapshot() == null) {
            return false;
        }
        if (other.snapshot() != null && !other.snapshot().equals(this.snapshot())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (snapshot() != null) {
            sb.append("Snapshot: ").append(snapshot()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateSnapshotResponse> {
        /**
         * <p>
         * Describes a snapshot.
         * </p>
         * 
         * @param snapshot
         *        Describes a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshot(Snapshot snapshot);
    }

    private static final class BuilderImpl implements Builder {
        private Snapshot snapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotResponse model) {
            setSnapshot(model.snapshot);
        }

        public final Snapshot getSnapshot() {
            return snapshot;
        }

        @Override
        public final Builder snapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public final void setSnapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        @Override
        public CreateSnapshotResponse build() {
            return new CreateSnapshotResponse(this);
        }
    }
}
