/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateVolume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVolumeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateVolumeRequest.Builder, CreateVolumeRequest> {
    private final String availabilityZone;

    private final Boolean encrypted;

    private final Integer iops;

    private final String kmsKeyId;

    private final Integer size;

    private final String snapshotId;

    private final String volumeType;

    private final List<TagSpecification> tagSpecifications;

    private CreateVolumeRequest(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.encrypted = builder.encrypted;
        this.iops = builder.iops;
        this.kmsKeyId = builder.kmsKeyId;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.volumeType = builder.volumeType;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The Availability Zone in which to create the volume. Use <a>DescribeAvailabilityZones</a> to list the
     * Availability Zones that are currently available to you.
     * </p>
     * 
     * @return The Availability Zone in which to create the volume. Use <a>DescribeAvailabilityZones</a> to list the
     *         Availability Zones that are currently available to you.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Specifies whether the volume should be encrypted. Encrypted Amazon EBS volumes may only be attached to instances
     * that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are automatically
     * encrypted. There is no way to create an encrypted volume from an unencrypted snapshot or vice versa. If your AMI
     * uses encrypted volumes, you can only launch it on supported instance types. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Specifies whether the volume should be encrypted. Encrypted Amazon EBS volumes may only be attached to
     *         instances that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are
     *         automatically encrypted. There is no way to create an encrypted volume from an unencrypted snapshot or
     *         vice versa. If your AMI uses encrypted volumes, you can only launch it on supported instance types. For
     *         more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in
     *         the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * Only valid for Provisioned IOPS SSD volumes. The number of I/O operations per second (IOPS) to provision for the
     * volume, with a maximum ratio of 50 IOPS/GiB.
     * </p>
     * <p>
     * Constraint: Range is 100 to 20000 for Provisioned IOPS SSD volumes
     * </p>
     * 
     * @return Only valid for Provisioned IOPS SSD volumes. The number of I/O operations per second (IOPS) to provision
     *         for the volume, with a maximum ratio of 50 IOPS/GiB.</p>
     *         <p>
     *         Constraint: Range is 100 to 20000 for Provisioned IOPS SSD volumes
     */
    public Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating the
     * encrypted volume. This parameter is only required if you want to use a non-default CMK; if this parameter is not
     * specified, the default CMK for EBS is used. The ARN contains the <code>arn:aws:kms</code> namespace, followed by
     * the region of the CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK ID.
     * For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. If
     * a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.
     * </p>
     * 
     * @return The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating
     *         the encrypted volume. This parameter is only required if you want to use a non-default CMK; if this
     *         parameter is not specified, the default CMK for EBS is used. The ARN contains the
     *         <code>arn:aws:kms</code> namespace, followed by the region of the CMK, the AWS account ID of the CMK
     *         owner, the <code>key</code> namespace, and then the CMK ID. For example,
     *         arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. If a
     *         <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The size of the volume, in GiBs.
     * </p>
     * <p>
     * Constraints: 1-16384 for <code>gp2</code>, 4-16384 for <code>io1</code>, 500-16384 for <code>st1</code>,
     * 500-16384 for <code>sc1</code>, and 1-1024 for <code>standard</code>. If you specify a snapshot, the volume size
     * must be equal to or larger than the snapshot size.
     * </p>
     * <p>
     * Default: If you're creating the volume from a snapshot and don't specify a volume size, the default is the
     * snapshot size.
     * </p>
     * 
     * @return The size of the volume, in GiBs.</p>
     *         <p>
     *         Constraints: 1-16384 for <code>gp2</code>, 4-16384 for <code>io1</code>, 500-16384 for <code>st1</code>,
     *         500-16384 for <code>sc1</code>, and 1-1024 for <code>standard</code>. If you specify a snapshot, the
     *         volume size must be equal to or larger than the snapshot size.
     *         </p>
     *         <p>
     *         Default: If you're creating the volume from a snapshot and don't specify a volume size, the default is
     *         the snapshot size.
     */
    public Integer size() {
        return size;
    }

    /**
     * <p>
     * The snapshot from which to create the volume.
     * </p>
     * 
     * @return The snapshot from which to create the volume.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS SSD,
     * <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for
     * Magnetic volumes.
     * </p>
     * <p>
     * Default: <code>standard</code>
     * </p>
     * 
     * @return The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned
     *         IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or
     *         <code>standard</code> for Magnetic volumes.</p>
     *         <p>
     *         Default: <code>standard</code>
     * @see VolumeType
     */
    public String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * The tags to apply to the volume during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to apply to the volume during creation.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((encrypted() == null) ? 0 : encrypted().hashCode());
        hashCode = 31 * hashCode + ((iops() == null) ? 0 : iops().hashCode());
        hashCode = 31 * hashCode + ((kmsKeyId() == null) ? 0 : kmsKeyId().hashCode());
        hashCode = 31 * hashCode + ((size() == null) ? 0 : size().hashCode());
        hashCode = 31 * hashCode + ((snapshotId() == null) ? 0 : snapshotId().hashCode());
        hashCode = 31 * hashCode + ((volumeType() == null) ? 0 : volumeType().hashCode());
        hashCode = 31 * hashCode + ((tagSpecifications() == null) ? 0 : tagSpecifications().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumeRequest)) {
            return false;
        }
        CreateVolumeRequest other = (CreateVolumeRequest) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.encrypted() == null ^ this.encrypted() == null) {
            return false;
        }
        if (other.encrypted() != null && !other.encrypted().equals(this.encrypted())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.volumeType() == null ^ this.volumeType() == null) {
            return false;
        }
        if (other.volumeType() != null && !other.volumeType().equals(this.volumeType())) {
            return false;
        }
        if (other.tagSpecifications() == null ^ this.tagSpecifications() == null) {
            return false;
        }
        if (other.tagSpecifications() != null && !other.tagSpecifications().equals(this.tagSpecifications())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (encrypted() != null) {
            sb.append("Encrypted: ").append(encrypted()).append(",");
        }
        if (iops() != null) {
            sb.append("Iops: ").append(iops()).append(",");
        }
        if (kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(kmsKeyId()).append(",");
        }
        if (size() != null) {
            sb.append("Size: ").append(size()).append(",");
        }
        if (snapshotId() != null) {
            sb.append("SnapshotId: ").append(snapshotId()).append(",");
        }
        if (volumeType() != null) {
            sb.append("VolumeType: ").append(volumeType()).append(",");
        }
        if (tagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(tagSpecifications()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVolumeRequest> {
        /**
         * <p>
         * The Availability Zone in which to create the volume. Use <a>DescribeAvailabilityZones</a> to list the
         * Availability Zones that are currently available to you.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which to create the volume. Use <a>DescribeAvailabilityZones</a> to list the
         *        Availability Zones that are currently available to you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Specifies whether the volume should be encrypted. Encrypted Amazon EBS volumes may only be attached to
         * instances that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are
         * automatically encrypted. There is no way to create an encrypted volume from an unencrypted snapshot or vice
         * versa. If your AMI uses encrypted volumes, you can only launch it on supported instance types. For more
         * information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS
         * Encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param encrypted
         *        Specifies whether the volume should be encrypted. Encrypted Amazon EBS volumes may only be attached to
         *        instances that support Amazon EBS encryption. Volumes that are created from encrypted snapshots are
         *        automatically encrypted. There is no way to create an encrypted volume from an unencrypted snapshot or
         *        vice versa. If your AMI uses encrypted volumes, you can only launch it on supported instance types.
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>
         *        in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * Only valid for Provisioned IOPS SSD volumes. The number of I/O operations per second (IOPS) to provision for
         * the volume, with a maximum ratio of 50 IOPS/GiB.
         * </p>
         * <p>
         * Constraint: Range is 100 to 20000 for Provisioned IOPS SSD volumes
         * </p>
         * 
         * @param iops
         *        Only valid for Provisioned IOPS SSD volumes. The number of I/O operations per second (IOPS) to
         *        provision for the volume, with a maximum ratio of 50 IOPS/GiB.</p>
         *        <p>
         *        Constraint: Range is 100 to 20000 for Provisioned IOPS SSD volumes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating the
         * encrypted volume. This parameter is only required if you want to use a non-default CMK; if this parameter is
         * not specified, the default CMK for EBS is used. The ARN contains the <code>arn:aws:kms</code> namespace,
         * followed by the region of the CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and
         * then the CMK ID. For example,
         * arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. If a
         * <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.
         * </p>
         * 
         * @param kmsKeyId
         *        The full ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use when
         *        creating the encrypted volume. This parameter is only required if you want to use a non-default CMK;
         *        if this parameter is not specified, the default CMK for EBS is used. The ARN contains the
         *        <code>arn:aws:kms</code> namespace, followed by the region of the CMK, the AWS account ID of the CMK
         *        owner, the <code>key</code> namespace, and then the CMK ID. For example,
         *        arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. If a
         *        <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The size of the volume, in GiBs.
         * </p>
         * <p>
         * Constraints: 1-16384 for <code>gp2</code>, 4-16384 for <code>io1</code>, 500-16384 for <code>st1</code>,
         * 500-16384 for <code>sc1</code>, and 1-1024 for <code>standard</code>. If you specify a snapshot, the volume
         * size must be equal to or larger than the snapshot size.
         * </p>
         * <p>
         * Default: If you're creating the volume from a snapshot and don't specify a volume size, the default is the
         * snapshot size.
         * </p>
         * 
         * @param size
         *        The size of the volume, in GiBs.</p>
         *        <p>
         *        Constraints: 1-16384 for <code>gp2</code>, 4-16384 for <code>io1</code>, 500-16384 for
         *        <code>st1</code>, 500-16384 for <code>sc1</code>, and 1-1024 for <code>standard</code>. If you specify
         *        a snapshot, the volume size must be equal to or larger than the snapshot size.
         *        </p>
         *        <p>
         *        Default: If you're creating the volume from a snapshot and don't specify a volume size, the default is
         *        the snapshot size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The snapshot from which to create the volume.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot from which to create the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS
         * SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code>
         * for Magnetic volumes.
         * </p>
         * <p>
         * Default: <code>standard</code>
         * </p>
         * 
         * @param volumeType
         *        The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for
         *        Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or
         *        <code>standard</code> for Magnetic volumes.</p>
         *        <p>
         *        Default: <code>standard</code>
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for Provisioned IOPS
         * SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code>
         * for Magnetic volumes.
         * </p>
         * <p>
         * Default: <code>standard</code>
         * </p>
         * 
         * @param volumeType
         *        The volume type. This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> for
         *        Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or
         *        <code>standard</code> for Magnetic volumes.</p>
         *        <p>
         *        Default: <code>standard</code>
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);

        /**
         * <p>
         * The tags to apply to the volume during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the volume during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the volume during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the volume during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);
    }

    private static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Boolean encrypted;

        private Integer iops;

        private String kmsKeyId;

        private Integer size;

        private String snapshotId;

        private String volumeType;

        private List<TagSpecification> tagSpecifications;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumeRequest model) {
            setAvailabilityZone(model.availabilityZone);
            setEncrypted(model.encrypted);
            setIops(model.iops);
            setKmsKeyId(model.kmsKeyId);
            setSize(model.size);
            setSnapshotId(model.snapshotId);
            setVolumeType(model.volumeType);
            setTagSpecifications(model.tagSpecifications);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Collection<TagSpecification> getTagSpecifications() {
            return tagSpecifications;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
        }

        @Override
        public CreateVolumeRequest build() {
            return new CreateVolumeRequest(this);
        }
    }
}
