/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateVpnGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpnGatewayResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateVpnGatewayResponse.Builder, CreateVpnGatewayResponse> {
    private final VpnGateway vpnGateway;

    private CreateVpnGatewayResponse(BuilderImpl builder) {
        this.vpnGateway = builder.vpnGateway;
    }

    /**
     * <p>
     * Information about the virtual private gateway.
     * </p>
     * 
     * @return Information about the virtual private gateway.
     */
    public VpnGateway vpnGateway() {
        return vpnGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpnGateway() == null) ? 0 : vpnGateway().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpnGatewayResponse)) {
            return false;
        }
        CreateVpnGatewayResponse other = (CreateVpnGatewayResponse) obj;
        if (other.vpnGateway() == null ^ this.vpnGateway() == null) {
            return false;
        }
        if (other.vpnGateway() != null && !other.vpnGateway().equals(this.vpnGateway())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (vpnGateway() != null) {
            sb.append("VpnGateway: ").append(vpnGateway()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVpnGatewayResponse> {
        /**
         * <p>
         * Information about the virtual private gateway.
         * </p>
         * 
         * @param vpnGateway
         *        Information about the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGateway(VpnGateway vpnGateway);
    }

    private static final class BuilderImpl implements Builder {
        private VpnGateway vpnGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpnGatewayResponse model) {
            setVpnGateway(model.vpnGateway);
        }

        public final VpnGateway getVpnGateway() {
            return vpnGateway;
        }

        @Override
        public final Builder vpnGateway(VpnGateway vpnGateway) {
            this.vpnGateway = vpnGateway;
            return this;
        }

        public final void setVpnGateway(VpnGateway vpnGateway) {
            this.vpnGateway = vpnGateway;
        }

        @Override
        public CreateVpnGatewayResponse build() {
            return new CreateVpnGatewayResponse(this);
        }
    }
}
