/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DeleteFlowLogs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteFlowLogsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteFlowLogsResponse.Builder, DeleteFlowLogsResponse> {
    private final List<UnsuccessfulItem> unsuccessful;

    private DeleteFlowLogsResponse(BuilderImpl builder) {
        this.unsuccessful = builder.unsuccessful;
    }

    /**
     * <p>
     * Information about the flow logs that could not be deleted successfully.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the flow logs that could not be deleted successfully.
     */
    public List<UnsuccessfulItem> unsuccessful() {
        return unsuccessful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((unsuccessful() == null) ? 0 : unsuccessful().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFlowLogsResponse)) {
            return false;
        }
        DeleteFlowLogsResponse other = (DeleteFlowLogsResponse) obj;
        if (other.unsuccessful() == null ^ this.unsuccessful() == null) {
            return false;
        }
        if (other.unsuccessful() != null && !other.unsuccessful().equals(this.unsuccessful())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (unsuccessful() != null) {
            sb.append("Unsuccessful: ").append(unsuccessful()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteFlowLogsResponse> {
        /**
         * <p>
         * Information about the flow logs that could not be deleted successfully.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the flow logs that could not be deleted successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful);

        /**
         * <p>
         * Information about the flow logs that could not be deleted successfully.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the flow logs that could not be deleted successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(UnsuccessfulItem... unsuccessful);
    }

    private static final class BuilderImpl implements Builder {
        private List<UnsuccessfulItem> unsuccessful;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFlowLogsResponse model) {
            setUnsuccessful(model.unsuccessful);
        }

        public final Collection<UnsuccessfulItem> getUnsuccessful() {
            return unsuccessful;
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem... unsuccessful) {
            unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copy(unsuccessful);
        }

        @Override
        public DeleteFlowLogsResponse build() {
            return new DeleteFlowLogsResponse(this);
        }
    }
}
