/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteNatGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteNatGatewayRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteNatGatewayRequest.Builder, DeleteNatGatewayRequest> {
    private final String natGatewayId;

    private DeleteNatGatewayRequest(BuilderImpl builder) {
        this.natGatewayId = builder.natGatewayId;
    }

    /**
     * <p>
     * The ID of the NAT gateway.
     * </p>
     * 
     * @return The ID of the NAT gateway.
     */
    public String natGatewayId() {
        return natGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((natGatewayId() == null) ? 0 : natGatewayId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNatGatewayRequest)) {
            return false;
        }
        DeleteNatGatewayRequest other = (DeleteNatGatewayRequest) obj;
        if (other.natGatewayId() == null ^ this.natGatewayId() == null) {
            return false;
        }
        if (other.natGatewayId() != null && !other.natGatewayId().equals(this.natGatewayId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (natGatewayId() != null) {
            sb.append("NatGatewayId: ").append(natGatewayId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteNatGatewayRequest> {
        /**
         * <p>
         * The ID of the NAT gateway.
         * </p>
         * 
         * @param natGatewayId
         *        The ID of the NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);
    }

    private static final class BuilderImpl implements Builder {
        private String natGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNatGatewayRequest model) {
            setNatGatewayId(model.natGatewayId);
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        @Override
        public DeleteNatGatewayRequest build() {
            return new DeleteNatGatewayRequest(this);
        }
    }
}
