/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteNetworkAcl.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteNetworkAclRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteNetworkAclRequest.Builder, DeleteNetworkAclRequest> {
    private final String networkAclId;

    private DeleteNetworkAclRequest(BuilderImpl builder) {
        this.networkAclId = builder.networkAclId;
    }

    /**
     * <p>
     * The ID of the network ACL.
     * </p>
     * 
     * @return The ID of the network ACL.
     */
    public String networkAclId() {
        return networkAclId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((networkAclId() == null) ? 0 : networkAclId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkAclRequest)) {
            return false;
        }
        DeleteNetworkAclRequest other = (DeleteNetworkAclRequest) obj;
        if (other.networkAclId() == null ^ this.networkAclId() == null) {
            return false;
        }
        if (other.networkAclId() != null && !other.networkAclId().equals(this.networkAclId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (networkAclId() != null) {
            sb.append("NetworkAclId: ").append(networkAclId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteNetworkAclRequest> {
        /**
         * <p>
         * The ID of the network ACL.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);
    }

    private static final class BuilderImpl implements Builder {
        private String networkAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkAclRequest model) {
            setNetworkAclId(model.networkAclId);
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        @Override
        public DeleteNetworkAclRequest build() {
            return new DeleteNetworkAclRequest(this);
        }
    }
}
