/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteVpcPeeringConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteVpcPeeringConnectionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteVpcPeeringConnectionRequest.Builder, DeleteVpcPeeringConnectionRequest> {
    private final String vpcPeeringConnectionId;

    private DeleteVpcPeeringConnectionRequest(BuilderImpl builder) {
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The ID of the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC peering connection.
     */
    public String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpcPeeringConnectionId() == null) ? 0 : vpcPeeringConnectionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcPeeringConnectionRequest)) {
            return false;
        }
        DeleteVpcPeeringConnectionRequest other = (DeleteVpcPeeringConnectionRequest) obj;
        if (other.vpcPeeringConnectionId() == null ^ this.vpcPeeringConnectionId() == null) {
            return false;
        }
        if (other.vpcPeeringConnectionId() != null && !other.vpcPeeringConnectionId().equals(this.vpcPeeringConnectionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (vpcPeeringConnectionId() != null) {
            sb.append("VpcPeeringConnectionId: ").append(vpcPeeringConnectionId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteVpcPeeringConnectionRequest> {
        /**
         * <p>
         * The ID of the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    private static final class BuilderImpl implements Builder {
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcPeeringConnectionRequest model) {
            setVpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public DeleteVpcPeeringConnectionRequest build() {
            return new DeleteVpcPeeringConnectionRequest(this);
        }
    }
}
