/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeDhcpOptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDhcpOptionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeDhcpOptionsRequest.Builder, DescribeDhcpOptionsRequest> {
    private final List<String> dhcpOptionsIds;

    private final List<Filter> filters;

    private DescribeDhcpOptionsRequest(BuilderImpl builder) {
        this.dhcpOptionsIds = builder.dhcpOptionsIds;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The IDs of one or more DHCP options sets.
     * </p>
     * <p>
     * Default: Describes all your DHCP options sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of one or more DHCP options sets.</p>
     *         <p>
     *         Default: Describes all your DHCP options sets.
     */
    public List<String> dhcpOptionsIds() {
        return dhcpOptionsIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>dhcp-options-id</code> - The ID of a set of DHCP options.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>key</code> - The key for one of the options (for example, <code>domain-name</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>value</code> - The value for one of the options.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>dhcp-options-id</code> - The ID of a set of DHCP options.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>key</code> - The key for one of the options (for example, <code>domain-name</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>value</code> - The value for one of the options.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dhcpOptionsIds() == null) ? 0 : dhcpOptionsIds().hashCode());
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDhcpOptionsRequest)) {
            return false;
        }
        DescribeDhcpOptionsRequest other = (DescribeDhcpOptionsRequest) obj;
        if (other.dhcpOptionsIds() == null ^ this.dhcpOptionsIds() == null) {
            return false;
        }
        if (other.dhcpOptionsIds() != null && !other.dhcpOptionsIds().equals(this.dhcpOptionsIds())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (dhcpOptionsIds() != null) {
            sb.append("DhcpOptionsIds: ").append(dhcpOptionsIds()).append(",");
        }
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDhcpOptionsRequest> {
        /**
         * <p>
         * The IDs of one or more DHCP options sets.
         * </p>
         * <p>
         * Default: Describes all your DHCP options sets.
         * </p>
         * 
         * @param dhcpOptionsIds
         *        The IDs of one or more DHCP options sets.</p>
         *        <p>
         *        Default: Describes all your DHCP options sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptionsIds(Collection<String> dhcpOptionsIds);

        /**
         * <p>
         * The IDs of one or more DHCP options sets.
         * </p>
         * <p>
         * Default: Describes all your DHCP options sets.
         * </p>
         * 
         * @param dhcpOptionsIds
         *        The IDs of one or more DHCP options sets.</p>
         *        <p>
         *        Default: Describes all your DHCP options sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptionsIds(String... dhcpOptionsIds);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>dhcp-options-id</code> - The ID of a set of DHCP options.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key</code> - The key for one of the options (for example, <code>domain-name</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>value</code> - The value for one of the options.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>dhcp-options-id</code> - The ID of a set of DHCP options.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key</code> - The key for one of the options (for example, <code>domain-name</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>value</code> - The value for one of the options.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>dhcp-options-id</code> - The ID of a set of DHCP options.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key</code> - The key for one of the options (for example, <code>domain-name</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>value</code> - The value for one of the options.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>dhcp-options-id</code> - The ID of a set of DHCP options.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key</code> - The key for one of the options (for example, <code>domain-name</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>value</code> - The value for one of the options.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> dhcpOptionsIds;

        private List<Filter> filters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDhcpOptionsRequest model) {
            setDhcpOptionsIds(model.dhcpOptionsIds);
            setFilters(model.filters);
        }

        public final Collection<String> getDhcpOptionsIds() {
            return dhcpOptionsIds;
        }

        @Override
        public final Builder dhcpOptionsIds(Collection<String> dhcpOptionsIds) {
            this.dhcpOptionsIds = DhcpOptionsIdStringListCopier.copy(dhcpOptionsIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpOptionsIds(String... dhcpOptionsIds) {
            dhcpOptionsIds(Arrays.asList(dhcpOptionsIds));
            return this;
        }

        public final void setDhcpOptionsIds(Collection<String> dhcpOptionsIds) {
            this.dhcpOptionsIds = DhcpOptionsIdStringListCopier.copy(dhcpOptionsIds);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @Override
        public DescribeDhcpOptionsRequest build() {
            return new DescribeDhcpOptionsRequest(this);
        }
    }
}
