/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeFlowLogs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeFlowLogsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeFlowLogsResponse.Builder, DescribeFlowLogsResponse> {
    private final List<FlowLog> flowLogs;

    private final String nextToken;

    private DescribeFlowLogsResponse(BuilderImpl builder) {
        this.flowLogs = builder.flowLogs;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the flow logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the flow logs.
     */
    public List<FlowLog> flowLogs() {
        return flowLogs;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((flowLogs() == null) ? 0 : flowLogs().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowLogsResponse)) {
            return false;
        }
        DescribeFlowLogsResponse other = (DescribeFlowLogsResponse) obj;
        if (other.flowLogs() == null ^ this.flowLogs() == null) {
            return false;
        }
        if (other.flowLogs() != null && !other.flowLogs().equals(this.flowLogs())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (flowLogs() != null) {
            sb.append("FlowLogs: ").append(flowLogs()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeFlowLogsResponse> {
        /**
         * <p>
         * Information about the flow logs.
         * </p>
         * 
         * @param flowLogs
         *        Information about the flow logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogs(Collection<FlowLog> flowLogs);

        /**
         * <p>
         * Information about the flow logs.
         * </p>
         * 
         * @param flowLogs
         *        Information about the flow logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogs(FlowLog... flowLogs);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<FlowLog> flowLogs;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowLogsResponse model) {
            setFlowLogs(model.flowLogs);
            setNextToken(model.nextToken);
        }

        public final Collection<FlowLog> getFlowLogs() {
            return flowLogs;
        }

        @Override
        public final Builder flowLogs(Collection<FlowLog> flowLogs) {
            this.flowLogs = FlowLogSetCopier.copy(flowLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogs(FlowLog... flowLogs) {
            flowLogs(Arrays.asList(flowLogs));
            return this;
        }

        public final void setFlowLogs(Collection<FlowLog> flowLogs) {
            this.flowLogs = FlowLogSetCopier.copy(flowLogs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFlowLogsResponse build() {
            return new DescribeFlowLogsResponse(this);
        }
    }
}
