/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeHostReservationOfferingsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeHostReservationOfferingsRequest.Builder, DescribeHostReservationOfferingsRequest> {
    private final List<Filter> filter;

    private final Integer maxDuration;

    private final Integer maxResults;

    private final Integer minDuration;

    private final String nextToken;

    private final String offeringId;

    private DescribeHostReservationOfferingsRequest(BuilderImpl builder) {
        this.filter = builder.filter;
        this.maxDuration = builder.maxDuration;
        this.maxResults = builder.maxResults;
        this.minDuration = builder.minDuration;
        this.nextToken = builder.nextToken;
        this.offeringId = builder.offeringId;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance-family</code> - The instance family of the offering (e.g., <code>m4</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
     * <code>AllUpfront</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance-family</code> - The instance family of the offering (e.g., <code>m4</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
     *         <code>AllUpfront</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filter() {
        return filter;
    }

    /**
     * <p>
     * This is the maximum duration of the reservation you'd like to purchase, specified in seconds. Reservations are
     * available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a
     * year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 94608000 for three years.
     * </p>
     * 
     * @return This is the maximum duration of the reservation you'd like to purchase, specified in seconds.
     *         Reservations are available in one-year and three-year terms. The number of seconds specified must be the
     *         number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example,
     *         specify 94608000 for three years.
     */
    public Integer maxDuration() {
        return maxDuration;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500; if
     * <code>maxResults</code> is given a larger value than 500, you will receive an error.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the returned <code>nextToken</code> value. This value can be between
     *         5 and 500; if <code>maxResults</code> is given a larger value than 500, you will receive an error.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * This is the minimum duration of the reservation you'd like to purchase, specified in seconds. Reservations are
     * available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a
     * year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 31536000 for one year.
     * </p>
     * 
     * @return This is the minimum duration of the reservation you'd like to purchase, specified in seconds.
     *         Reservations are available in one-year and three-year terms. The number of seconds specified must be the
     *         number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example,
     *         specify 31536000 for one year.
     */
    public Integer minDuration() {
        return minDuration;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the reservation offering.
     * </p>
     * 
     * @return The ID of the reservation offering.
     */
    public String offeringId() {
        return offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filter() == null) ? 0 : filter().hashCode());
        hashCode = 31 * hashCode + ((maxDuration() == null) ? 0 : maxDuration().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((minDuration() == null) ? 0 : minDuration().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((offeringId() == null) ? 0 : offeringId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationOfferingsRequest)) {
            return false;
        }
        DescribeHostReservationOfferingsRequest other = (DescribeHostReservationOfferingsRequest) obj;
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.maxDuration() == null ^ this.maxDuration() == null) {
            return false;
        }
        if (other.maxDuration() != null && !other.maxDuration().equals(this.maxDuration())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.minDuration() == null ^ this.minDuration() == null) {
            return false;
        }
        if (other.minDuration() != null && !other.minDuration().equals(this.minDuration())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.offeringId() == null ^ this.offeringId() == null) {
            return false;
        }
        if (other.offeringId() != null && !other.offeringId().equals(this.offeringId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filter() != null) {
            sb.append("Filter: ").append(filter()).append(",");
        }
        if (maxDuration() != null) {
            sb.append("MaxDuration: ").append(maxDuration()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (minDuration() != null) {
            sb.append("MinDuration: ").append(minDuration()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (offeringId() != null) {
            sb.append("OfferingId: ").append(offeringId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeHostReservationOfferingsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-family</code> - The instance family of the offering (e.g., <code>m4</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
         * <code>AllUpfront</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-family</code> - The instance family of the offering (e.g., <code>m4</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code>
         *        | <code>AllUpfront</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Collection<Filter> filter);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-family</code> - The instance family of the offering (e.g., <code>m4</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
         * <code>AllUpfront</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-family</code> - The instance family of the offering (e.g., <code>m4</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code>
         *        | <code>AllUpfront</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter... filter);

        /**
         * <p>
         * This is the maximum duration of the reservation you'd like to purchase, specified in seconds. Reservations
         * are available in one-year and three-year terms. The number of seconds specified must be the number of seconds
         * in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 94608000 for
         * three years.
         * </p>
         * 
         * @param maxDuration
         *        This is the maximum duration of the reservation you'd like to purchase, specified in seconds.
         *        Reservations are available in one-year and three-year terms. The number of seconds specified must be
         *        the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For
         *        example, specify 94608000 for three years.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDuration(Integer maxDuration);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results can be seen
         * by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and
         * 500; if <code>maxResults</code> is given a larger value than 500, you will receive an error.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results can be
         *        seen by sending another request with the returned <code>nextToken</code> value. This value can be
         *        between 5 and 500; if <code>maxResults</code> is given a larger value than 500, you will receive an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * This is the minimum duration of the reservation you'd like to purchase, specified in seconds. Reservations
         * are available in one-year and three-year terms. The number of seconds specified must be the number of seconds
         * in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 31536000 for one
         * year.
         * </p>
         * 
         * @param minDuration
         *        This is the minimum duration of the reservation you'd like to purchase, specified in seconds.
         *        Reservations are available in one-year and three-year terms. The number of seconds specified must be
         *        the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For
         *        example, specify 31536000 for one year.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minDuration(Integer minDuration);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the reservation offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the reservation offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filter;

        private Integer maxDuration;

        private Integer maxResults;

        private Integer minDuration;

        private String nextToken;

        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationOfferingsRequest model) {
            setFilter(model.filter);
            setMaxDuration(model.maxDuration);
            setMaxResults(model.maxResults);
            setMinDuration(model.minDuration);
            setNextToken(model.nextToken);
            setOfferingId(model.offeringId);
        }

        public final Collection<Filter> getFilter() {
            return filter;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter... filter) {
            filter(Arrays.asList(filter));
            return this;
        }

        public final void setFilter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
        }

        public final Integer getMaxDuration() {
            return maxDuration;
        }

        @Override
        public final Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getMinDuration() {
            return minDuration;
        }

        @Override
        public final Builder minDuration(Integer minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public final void setMinDuration(Integer minDuration) {
            this.minDuration = minDuration;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public DescribeHostReservationOfferingsRequest build() {
            return new DescribeHostReservationOfferingsRequest(this);
        }
    }
}
