/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstancesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeInstancesRequest.Builder, DescribeInstancesRequest> {
    private final List<Filter> filters;

    private final List<String> instanceIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeInstancesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.instanceIds = builder.instanceIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (<code>default</code> |
     * <code>host</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for
     * example, <code>2010-09-15T17:15:20.000Z</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is
     * deleted on instance termination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example,
     * <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
     * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client-token</code> - The idempotency token you provided when you launched the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dns-name</code> - The public DNS name of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>image-id</code> - The ID of the image used to launch the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
     * <code>spot</code> | <code>scheduled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is an
     * opaque internal value and should be ignored. The low byte is set based on the state represented. The valid values
     * are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
     * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance.group-id</code> - The ID of the security group for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance.group-name</code> - The name of the security group for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ip-address</code> - The public IPv4 address of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kernel-id</code> - The kernel ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>key-name</code> - The name of the key pair used when the instance was launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the launch
     * group (for example, 0, 1, 2, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>launch-time</code> - The time when the instance was launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
     * <code>enabled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the
     * network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network interface is
     * the primary private IPv4 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP
     * address (IPv4) with a network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address
     * associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the
     * network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated
     * with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the
     * Elastic IP address (IPv4) for your network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.association.association-id</code> - The association ID returned when the network
     * interface was associated with an IPv4 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface is
     * attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the network
     * interface is attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.device-index</code> - The device index to which the network interface is
     * attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
     * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to an
     * instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted
     * when an instance is terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.description</code> - The description of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.group-name</code> - The name of a security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.mac-address</code> - The MAC address of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.network-interface-id</code> - The ID of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.requester-id</code> - The requester ID for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed by
     * AWS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
     * <code>in-use</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination
     * checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is
     * disabled. The value must be <code>false</code> for the network interface to perform network address translation
     * (NAT) in your VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The AWS account ID of the instance owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>placement-group-name</code> - The name of the placement group for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform</code> - The platform. Use <code>windows</code> if you have Windows instances; otherwise, leave
     * blank.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-ip-address</code> - The private IPv4 address of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-code</code> - The product code associated with the AMI used to launch the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ramdisk-id</code> - The RAM disk ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reason</code> - The reason for the current state of the instance (for example, shows
     * "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
     * Management Console, Auto Scaling, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time you
     * launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can be
     * associated with more than one instance if you launch multiple instances using the same launch request. For
     * example, if you launch one instance, you'll get one reservation ID. If you launch ten instances using the same
     * launch request, you'll also get one reservation ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>root-device-name</code> - The name of the root device for the instance (for example, <code>/dev/sda1</code>
     * or <code>/dev/xvda</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>root-device-type</code> - The type of root device that the instance uses (<code>ebs</code> |
     * <code>instance-store</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value of
     * <code>true</code> means that checking is enabled, and <code>false</code> means checking is disabled. The value
     * must be <code>false</code> for the instance to perform network address translation (NAT) in your VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>spot-instance-request-id</code> - The ID of the Spot instance request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state-reason-code</code> - The reason code for the state change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state-reason-message</code> - A message that describes the state change.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>subnet-id</code> - The ID of the subnet for the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
     * <code>host</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
     * <code>hvm</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC that the instance is running in.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
     *         <code>default</code> | <code>host</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance,
     *         for example, <code>2010-09-15T17:15:20.000Z</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume
     *         is deleted on instance termination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example,
     *         <code>/dev/sdh</code> or <code>xvdh</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
     *         <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client-token</code> - The idempotency token you provided when you launched the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dns-name</code> - The public DNS name of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as
     *         an ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>image-id</code> - The ID of the image used to launch the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
     *         <code>spot</code> | <code>scheduled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte
     *         is an opaque internal value and should be ignored. The low byte is set based on the state represented.
     *         The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and
     *         80 (stopped).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code>
     *         | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance.group-id</code> - The ID of the security group for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance.group-name</code> - The name of the security group for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ip-address</code> - The public IPv4 address of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kernel-id</code> - The kernel ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>key-name</code> - The name of the key pair used when the instance was launched.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the
     *         launch group (for example, 0, 1, 2, and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>launch-time</code> - The time when the instance was launched.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
     *         <code>enabled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with
     *         the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
     *         interface is the primary private IPv4 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic
     *         IP address (IPv4) with a network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4
     *         address associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound
     *         to the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
     *         associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated
     *         the Elastic IP address (IPv4) for your network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.association.association-id</code> - The association ID returned when the network
     *         interface was associated with an IPv4 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network
     *         interface is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the
     *         network interface is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.device-index</code> - The device index to which the network interface
     *         is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
     *         <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached
     *         to an instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is
     *         deleted when an instance is terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.description</code> - The description of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.group-id</code> - The ID of a security group associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.group-name</code> - The name of a security group associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.mac-address</code> - The MAC address of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.network-interface-id</code> - The ID of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.requester-id</code> - The requester ID for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.requester-managed</code> - Indicates whether the network interface is being
     *         managed by AWS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
     *         <code>in-use</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.source-dest-check</code> - Whether the network interface performs
     *         source/destination checking. A value of <code>true</code> means checking is enabled, and
     *         <code>false</code> means checking is disabled. The value must be <code>false</code> for the network
     *         interface to perform network address translation (NAT) in your VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The AWS account ID of the instance owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>placement-group-name</code> - The name of the placement group for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform</code> - The platform. Use <code>windows</code> if you have Windows instances; otherwise,
     *         leave blank.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-ip-address</code> - The private IPv4 address of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-code</code> - The product code associated with the AMI used to launch the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>
     *         ).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ramdisk-id</code> - The RAM disk ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reason</code> - The reason for the current state of the instance (for example, shows
     *         "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code
     *         filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example,
     *         AWS Management Console, Auto Scaling, and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time
     *         you launch an instance. A reservation ID has a one-to-one relationship with an instance launch request,
     *         but can be associated with more than one instance if you launch multiple instances using the same launch
     *         request. For example, if you launch one instance, you'll get one reservation ID. If you launch ten
     *         instances using the same launch request, you'll also get one reservation ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>root-device-name</code> - The name of the root device for the instance (for example,
     *         <code>/dev/sda1</code> or <code>/dev/xvda</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>root-device-type</code> - The type of root device that the instance uses (<code>ebs</code> |
     *         <code>instance-store</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A
     *         value of <code>true</code> means that checking is enabled, and <code>false</code> means checking is
     *         disabled. The value must be <code>false</code> for the instance to perform network address translation
     *         (NAT) in your VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>spot-instance-request-id</code> - The ID of the Spot instance request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state-reason-code</code> - The reason code for the state change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state-reason-message</code> - A message that describes the state change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>subnet-id</code> - The ID of the subnet for the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
     *         <code>host</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
     *         <code>hvm</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC that the instance is running in.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more instance IDs.
     * </p>
     * <p>
     * Default: Describes all your instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more instance IDs.</p>
     *         <p>
     *         Default: Describes all your instances.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this
     * parameter and the instance IDs parameter or tag filters in the same call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot
     *         specify this parameter and the instance IDs parameter or tag filters in the same call.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((instanceIds() == null) ? 0 : instanceIds().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesRequest)) {
            return false;
        }
        DescribeInstancesRequest other = (DescribeInstancesRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        if (other.instanceIds() != null && !other.instanceIds().equals(this.instanceIds())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (instanceIds() != null) {
            sb.append("InstanceIds: ").append(instanceIds()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInstancesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         * <code>default</code> | <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for
         * example, <code>2010-09-15T17:15:20.000Z</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is
         * deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example,
         * <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token you provided when you launched the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dns-name</code> - The public DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an
         * ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
         * <code>spot</code> | <code>scheduled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is
         * an opaque internal value and should be ignored. The low byte is set based on the state represented. The valid
         * values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
         * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-id</code> - The ID of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-name</code> - The name of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address</code> - The public IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair used when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the
         * launch group (for example, 0, 1, 2, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-time</code> - The time when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
         * <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         * interface is the primary private IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP
         * address (IPv4) with a network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the
         * Elastic IP address (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.association-id</code> - The association ID returned when the network
         * interface was associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface
         * is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the
         * network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.device-index</code> - The device index to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to
         * an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted
         * when an instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-name</code> - The name of a security group associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-id</code> - The requester ID for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed
         * by AWS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         * <code>in-use</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination
         * checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is
         * disabled. The value must be <code>false</code> for the network interface to perform network address
         * translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the instance owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-group-name</code> - The name of the placement group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. Use <code>windows</code> if you have Windows instances; otherwise,
         * leave blank.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reason</code> - The reason for the current state of the instance (for example, shows
         * "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
         * Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time you
         * launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can
         * be associated with more than one instance if you launch multiple instances using the same launch request. For
         * example, if you launch one instance, you'll get one reservation ID. If you launch ten instances using the
         * same launch request, you'll also get one reservation ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The name of the root device for the instance (for example,
         * <code>/dev/sda1</code> or <code>/dev/xvda</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of root device that the instance uses (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value
         * of <code>true</code> means that checking is enabled, and <code>false</code> means checking is disabled. The
         * value must be <code>false</code> for the instance to perform network address translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The ID of the Spot instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - A message that describes the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         * <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         * <code>hvm</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         *        <code>default</code> | <code>host</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the
         *        instance, for example, <code>2010-09-15T17:15:20.000Z</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS
         *        volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example,
         *        <code>/dev/sdh</code> or <code>xvdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         *        <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token you provided when you launched the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dns-name</code> - The public DNS name of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified
         *        as an ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-id</code> - The ID of the image used to launch the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
         *        <code>spot</code> | <code>scheduled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high
         *        byte is an opaque internal value and should be ignored. The low byte is set based on the state
         *        represented. The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64
         *        (stopping), and 80 (stopped).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-name</code> - The state of the instance (<code>pending</code> |
         *        <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> |
         *        <code>stopped</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance.group-id</code> - The ID of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance.group-name</code> - The name of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-address</code> - The public IPv4 address of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key-name</code> - The name of the key pair used when the instance was launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-index</code> - When launching multiple instances, this is the index for the instance in
         *        the launch group (for example, 0, 1, 2, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-time</code> - The time when the instance was launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (
         *        <code>disabled</code> | <code>enabled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with
         *        the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         *        interface is the primary private IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an
         *        Elastic IP address (IPv4) with a network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4
         *        address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4)
         *        bound to the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         *        associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.allocation-id</code> - The allocation ID returned when you
         *        allocated the Elastic IP address (IPv4) for your network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.association-id</code> - The association ID returned when the
         *        network interface was associated with an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which
         *        the network interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.device-index</code> - The device index to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.status</code> - The status of the attachment (
         *        <code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.attach-time</code> - The time that the network interface was
         *        attached to an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is
         *        deleted when an instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.description</code> - The description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-id</code> - The ID of a security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-name</code> - The name of a security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.mac-address</code> - The MAC address of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.requester-id</code> - The requester ID for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.requester-managed</code> - Indicates whether the network interface is being
         *        managed by AWS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         *        <code>in-use</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.source-dest-check</code> - Whether the network interface performs
         *        source/destination checking. A value of <code>true</code> means checking is enabled, and
         *        <code>false</code> means checking is disabled. The value must be <code>false</code> for the network
         *        interface to perform network address translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the instance owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placement-group-name</code> - The name of the placement group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform. Use <code>windows</code> if you have Windows instances;
         *        otherwise, leave blank.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IPv4 address of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code.type</code> - The type of product code (<code>devpay</code> |
         *        <code>marketplace</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reason</code> - The reason for the current state of the instance (for example, shows
         *        "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code
         *        filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for
         *        example, AWS Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any
         *        time you launch an instance. A reservation ID has a one-to-one relationship with an instance launch
         *        request, but can be associated with more than one instance if you launch multiple instances using the
         *        same launch request. For example, if you launch one instance, you'll get one reservation ID. If you
         *        launch ten instances using the same launch request, you'll also get one reservation ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-name</code> - The name of the root device for the instance (for example,
         *        <code>/dev/sda1</code> or <code>/dev/xvda</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-type</code> - The type of root device that the instance uses (<code>ebs</code> |
         *        <code>instance-store</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking.
         *        A value of <code>true</code> means that checking is enabled, and <code>false</code> means checking is
         *        disabled. The value must be <code>false</code> for the instance to perform network address translation
         *        (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-instance-request-id</code> - The ID of the Spot instance request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-code</code> - The reason code for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-message</code> - A message that describes the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         *        <code>host</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         *        <code>hvm</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         * <code>default</code> | <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the instance, for
         * example, <code>2010-09-15T17:15:20.000Z</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS volume is
         * deleted on instance termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example,
         * <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client-token</code> - The idempotency token you provided when you launched the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dns-name</code> - The public DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified as an
         * ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>image-id</code> - The ID of the image used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
         * <code>spot</code> | <code>scheduled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high byte is
         * an opaque internal value and should be ignored. The low byte is set based on the state represented. The valid
         * values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
         * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-id</code> - The ID of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance.group-name</code> - The name of the security group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ip-address</code> - The public IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kernel-id</code> - The kernel ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key-name</code> - The name of the key pair used when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-index</code> - When launching multiple instances, this is the index for the instance in the
         * launch group (for example, 0, 1, 2, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>launch-time</code> - The time when the instance was launched.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (<code>disabled</code> |
         * <code>enabled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with the
         * network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         * interface is the primary private IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an Elastic IP
         * address (IPv4) with a network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4 address
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         * associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.allocation-id</code> - The allocation ID returned when you allocated the
         * Elastic IP address (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.association.association-id</code> - The association ID returned when the network
         * interface was associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network interface
         * is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which the
         * network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.device-index</code> - The device index to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.status</code> - The status of the attachment (<code>attaching</code> |
         * <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.attach-time</code> - The time that the network interface was attached to
         * an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is deleted
         * when an instance is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.group-name</code> - The name of a security group associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-id</code> - The requester ID for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.requester-managed</code> - Indicates whether the network interface is being managed
         * by AWS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         * <code>in-use</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.source-dest-check</code> - Whether the network interface performs source/destination
         * checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is
         * disabled. The value must be <code>false</code> for the network interface to perform network address
         * translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the instance owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>placement-group-name</code> - The name of the placement group for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform. Use <code>windows</code> if you have Windows instances; otherwise,
         * leave blank.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-code.type</code> - The type of product code (<code>devpay</code> | <code>marketplace</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ramdisk-id</code> - The RAM disk ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reason</code> - The reason for the current state of the instance (for example, shows
         * "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
         * Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any time you
         * launch an instance. A reservation ID has a one-to-one relationship with an instance launch request, but can
         * be associated with more than one instance if you launch multiple instances using the same launch request. For
         * example, if you launch one instance, you'll get one reservation ID. If you launch ten instances using the
         * same launch request, you'll also get one reservation ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-name</code> - The name of the root device for the instance (for example,
         * <code>/dev/sda1</code> or <code>/dev/xvda</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>root-device-type</code> - The type of root device that the instance uses (<code>ebs</code> |
         * <code>instance-store</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking. A value
         * of <code>true</code> means that checking is enabled, and <code>false</code> means checking is disabled. The
         * value must be <code>false</code> for the instance to perform network address translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-instance-request-id</code> - The ID of the Spot instance request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-code</code> - The reason code for the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state-reason-message</code> - A message that describes the state change.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         * <code>host</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         * <code>hvm</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>affinity</code> - The affinity setting for an instance running on a Dedicated Host (
         *        <code>default</code> | <code>host</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>architecture</code> - The instance architecture (<code>i386</code> | <code>x86_64</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.attach-time</code> - The attach time for an EBS volume mapped to the
         *        instance, for example, <code>2010-09-15T17:15:20.000Z</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.delete-on-termination</code> - A Boolean that indicates whether the EBS
         *        volume is deleted on instance termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.device-name</code> - The device name for the EBS volume (for example,
         *        <code>/dev/sdh</code> or <code>xvdh</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.status</code> - The status for the EBS volume (<code>attaching</code> |
         *        <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>block-device-mapping.volume-id</code> - The volume ID of the EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client-token</code> - The idempotency token you provided when you launched the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dns-name</code> - The public DNS name of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of the security group for the instance. EC2-Classic only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of the security group for the instance. EC2-Classic only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>host-id</code> - The ID of the Dedicated Host on which the instance is running, if applicable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hypervisor</code> - The hypervisor type of the instance (<code>ovm</code> | <code>xen</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam-instance-profile.arn</code> - The instance profile associated with the instance. Specified
         *        as an ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>image-id</code> - The ID of the image used to launch the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-lifecycle</code> - Indicates whether this is a Spot Instance or a Scheduled Instance (
         *        <code>spot</code> | <code>scheduled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-code</code> - The state of the instance, as a 16-bit unsigned integer. The high
         *        byte is an opaque internal value and should be ignored. The low byte is set based on the state
         *        represented. The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64
         *        (stopping), and 80 (stopped).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-name</code> - The state of the instance (<code>pending</code> |
         *        <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> |
         *        <code>stopped</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The type of instance (for example, <code>t2.micro</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance.group-id</code> - The ID of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance.group-name</code> - The name of the security group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ip-address</code> - The public IPv4 address of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kernel-id</code> - The kernel ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key-name</code> - The name of the key pair used when the instance was launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-index</code> - When launching multiple instances, this is the index for the instance in
         *        the launch group (for example, 0, 1, 2, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>launch-time</code> - The time when the instance was launched.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>monitoring-state</code> - Indicates whether detailed monitoring is enabled (
         *        <code>disabled</code> | <code>enabled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.private-ip-address</code> - The private IPv4 address associated with
         *        the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.primary</code> - Specifies whether the IPv4 address of the network
         *        interface is the primary private IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.public-ip</code> - The ID of the association of an
         *        Elastic IP address (IPv4) with a network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.addresses.association.ip-owner-id</code> - The owner ID of the private IPv4
         *        address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.public-ip</code> - The address of the Elastic IP address (IPv4)
         *        bound to the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4)
         *        associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.allocation-id</code> - The allocation ID returned when you
         *        allocated the Elastic IP address (IPv4) for your network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.association.association-id</code> - The association ID returned when the
         *        network interface was associated with an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.attachment-id</code> - The ID of the interface attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.instance-id</code> - The ID of the instance to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.instance-owner-id</code> - The owner ID of the instance to which
         *        the network interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.device-index</code> - The device index to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.status</code> - The status of the attachment (
         *        <code>attaching</code> | <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.attach-time</code> - The time that the network interface was
         *        attached to an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.attachment.delete-on-termination</code> - Specifies whether the attachment is
         *        deleted when an instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.availability-zone</code> - The Availability Zone for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.description</code> - The description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-id</code> - The ID of a security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.group-name</code> - The name of a security group associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.ipv6-addresses.ipv6-address</code> - The IPv6 address associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.mac-address</code> - The MAC address of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.owner-id</code> - The ID of the owner of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.private-dns-name</code> - The private DNS name of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.requester-id</code> - The requester ID for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.requester-managed</code> - Indicates whether the network interface is being
         *        managed by AWS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.status</code> - The status of the network interface (<code>available</code>) |
         *        <code>in-use</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.source-dest-check</code> - Whether the network interface performs
         *        source/destination checking. A value of <code>true</code> means checking is enabled, and
         *        <code>false</code> means checking is disabled. The value must be <code>false</code> for the network
         *        interface to perform network address translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.subnet-id</code> - The ID of the subnet for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface.vpc-id</code> - The ID of the VPC for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the instance owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>placement-group-name</code> - The name of the placement group for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform. Use <code>windows</code> if you have Windows instances;
         *        otherwise, leave blank.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name</code> - The private IPv4 DNS name of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IPv4 address of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code</code> - The product code associated with the AMI used to launch the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-code.type</code> - The type of product code (<code>devpay</code> |
         *        <code>marketplace</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ramdisk-id</code> - The RAM disk ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reason</code> - The reason for the current state of the instance (for example, shows
         *        "User Initiated [date]" when you stop or terminate the instance). Similar to the state-reason-code
         *        filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for
         *        example, AWS Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>reservation-id</code> - The ID of the instance's reservation. A reservation ID is created any
         *        time you launch an instance. A reservation ID has a one-to-one relationship with an instance launch
         *        request, but can be associated with more than one instance if you launch multiple instances using the
         *        same launch request. For example, if you launch one instance, you'll get one reservation ID. If you
         *        launch ten instances using the same launch request, you'll also get one reservation ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-name</code> - The name of the root device for the instance (for example,
         *        <code>/dev/sda1</code> or <code>/dev/xvda</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>root-device-type</code> - The type of root device that the instance uses (<code>ebs</code> |
         *        <code>instance-store</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-dest-check</code> - Indicates whether the instance performs source/destination checking.
         *        A value of <code>true</code> means that checking is enabled, and <code>false</code> means checking is
         *        disabled. The value must be <code>false</code> for the instance to perform network address translation
         *        (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-instance-request-id</code> - The ID of the Spot instance request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-code</code> - The reason code for the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state-reason-message</code> - A message that describes the state change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet for the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tenancy</code> - The tenancy of an instance (<code>dedicated</code> | <code>default</code> |
         *        <code>host</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>virtualization-type</code> - The virtualization type of the instance (<code>paravirtual</code> |
         *        <code>hvm</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC that the instance is running in.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more instance IDs.
         * </p>
         * <p>
         * Default: Describes all your instances.
         * </p>
         * 
         * @param instanceIds
         *        One or more instance IDs.</p>
         *        <p>
         *        Default: Describes all your instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * One or more instance IDs.
         * </p>
         * <p>
         * Default: Describes all your instances.
         * </p>
         * 
         * @param instanceIds
         *        One or more instance IDs.</p>
         *        <p>
         *        Default: Describes all your instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify
         * this parameter and the instance IDs parameter or tag filters in the same call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You
         *        cannot specify this parameter and the instance IDs parameter or tag filters in the same call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> instanceIds;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesRequest model) {
            setFilters(model.filters);
            setInstanceIds(model.instanceIds);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstancesRequest build() {
            return new DescribeInstancesRequest(this);
        }
    }
}
